// Sample code to demonstrate patching COMMDLG.DLL to overcome
//         bugs in the ChooseColor() and ChooseFont() functions

#include <windows.h>
#include <commdlg.h>
#include <string.h> // for _fmemset()

// main program sets to TRUE if CTL3D lib loaded.
extern  BOOL            bCtl3d;
static  BOOL            bColorPatched;
static  BOOL            bFontPatched;
static  BYTE            saved_patch[16];

UINT FAR PASCAL __export hook_choose_color
            (HWND hWnd, UINT message,
            WPARAM wParam, LPARAM lParam);
UINT FAR PASCAL __export hook_choose_font
            (HWND hWnd, UINT message,
            WPARAM wParam, LPARAM lParam);


void PASCAL test_choose_color (HWND hWndMain, BOOL bPatch, COLORREF FAR *custom_colors)
{
    CHOOSECOLOR    choose_color;

    // Initialize our structure
    _fmemset (&choose_color, 0, sizeof(CHOOSECOLOR));
    choose_color.lStructSize      = sizeof(CHOOSECOLOR);
    choose_color.hwndOwner        = hWndMain;
    choose_color.hInstance        = NULL;
    choose_color.rgbResult        = 0;
    choose_color.lpCustColors     = custom_colors;
    choose_color.Flags            = CC_FULLOPEN | ((bPatch)
                                        ? CC_ENABLEHOOK : 0);
    choose_color.lCustData        = 0;
    choose_color.lpfnHook         = (bPatch) ? 
                                    hook_choose_color : NULL;
    choose_color.lpTemplateName   = NULL;

    // Do the dialog
    bColorPatched = FALSE;
    ChooseColor (&choose_color);

    // If the patches didn't get un-applied, do so now
    if (bColorPatched)
        hook_choose_color (NULL, WM_ACTIVATE, FALSE, 0);
}


#ifdef __BORLANDC__
    #pragma argsused
#endif
UINT FAR PASCAL __export hook_choose_color (HWND hWnd,
                 UINT message, WPARAM wParam, LPARAM lParam)
{
UINT    code_selector, data_selector;
LPBYTE  lpPatch1, lpPatch2, lpPatch3, lpPatch4, lpPatch5;
WORD    i;

    // We're only interesed in activation events
    if (message != WM_ACTIVATE)
        return 0;

    // Make sure segment is as large as needed for our tests
    code_selector = HIWORD(ChooseColor);
    if (GetSelectorLimit (code_selector) < 0x1DAC)
        return 0;

    // Get writable selector for segment we need to write to
    data_selector = AllocSelector (code_selector);
    if (!data_selector)
        return 0;
    if (PrestoChangoSelector (code_selector, data_selector))
    {
        // Calculate the addresses we need to write to
        lpPatch1 = MAKELP(data_selector, 0x105F);
        lpPatch2 = MAKELP(data_selector, 0x10EF);
        lpPatch3 = MAKELP(data_selector, 0x1D9C);
        lpPatch4 = MAKELP(data_selector, 0x058B);
        lpPatch5 = MAKELP(data_selector, 0x05A1);

        // Are we being activated or de-activated?
        if (wParam)
        {
            // Make sure we're patching the correct code
            if ((lpPatch1[1] == 0x05) &&
                (lpPatch1[2] == 0x00) &&
                (lpPatch2[1] == 0x05) &&
                (lpPatch2[2] == 0x00) &&
                (lpPatch3[0] == 0xFF) &&
                (lpPatch3[1] == 0x76) &&
                (lpPatch3[2] == 0x06))
            {
                // Fix the segment, and apply the patches
                // (and save some code)
                GlobalFix ((HGLOBAL)code_selector);
                if (bCtl3d)
                {
                    lpPatch1[1] = 0x0F;
                    lpPatch2[1] = 0x0F;
                    for (i=0;i<9;i++)
                    {
                        saved_patch[i] = lpPatch3[i];
                        lpPatch3[i] = lpPatch1[i];
                    }
                    for (i=9;i<16;i++)
                    {
                        saved_patch[i] = lpPatch3[i];
                        lpPatch3[i] = 0x90;
                    }
                }
                lpPatch4[0] = lpPatch5[0] = 0x99;
                lpPatch4[1] = lpPatch5[1] = 0x90;
                lpPatch4[3] = lpPatch5[3] = 0x3E;
                bColorPatched = TRUE;
            }
        }
        else
        {
            // If previously patched, un-apply them now
            if (bColorPatched)
            {
                // Un-apply patches, and un-fix the segment
                if (bCtl3d)
                {
                    lpPatch1[1] = 0x05;
                    lpPatch2[1] = 0x05;
                    for (i=0;i<16;i++)
                        lpPatch3[i] = saved_patch[i];
                }
                lpPatch4[0] = lpPatch5[0] = 0x2B;
                lpPatch4[1] = lpPatch5[1] = 0xD2;
                lpPatch4[3] = lpPatch5[3] = 0x36;
                GlobalUnfix ((HGLOBAL)code_selector);
                bColorPatched = FALSE;
            }
        }
    }

    // Free the selector we allocated, and we're done
    FreeSelector (data_selector);
    return 0;
}


void PASCAL test_choose_font (HWND hWndMain,
                                                BOOL bPatch)
{
    LOGFONT        lf;
    CHOOSEFONT    choose_font;

    // Initialize the CHOOSEFONT structure
    _fmemset (&choose_font, 0, sizeof(CHOOSEFONT));
    choose_font.lStructSize  = sizeof(CHOOSEFONT);
    choose_font.hwndOwner    = hWndMain;
    choose_font.lpLogFont    = &lf;
    choose_font.Flags        = CF_SCREENFONTS |
                   ((bPatch && bCtl3d) ? CF_ENABLEHOOK : 0);
    choose_font.lpfnHook     = (bPatch && bCtl3d) ?
                                    hook_choose_font : NULL;

    // Do the dialog
    bFontPatched = FALSE;
    ChooseFont (&choose_font);

    // If the code is still patched, un-patch it now
    if (bFontPatched)
        hook_choose_font (NULL, WM_ACTIVATE, FALSE, 0);
}


#ifdef __BORLANDC__
    #pragma argsused
#endif
UINT FAR PASCAL __export hook_choose_font (HWND hWnd,
            UINT message, WPARAM wParam, LPARAM lParam)
{
    UINT      code_selector, data_selector;
    LPBYTE    lpPatch1;

    // We're only interested in activation events
    if (message != WM_ACTIVATE)
        return 0;

    // Make sure segment is as large as needed for our tests
    code_selector = HIWORD(ChooseFont);
    if (GetSelectorLimit (code_selector) < 0x22B0)
        return 0;

    // Get writable selector for segment we need to write to
    data_selector = AllocSelector (code_selector);
    if (!data_selector)
        return 0;
    if (PrestoChangoSelector (code_selector, data_selector))
    {
        // Calculate the address we need to write to
        lpPatch1 = MAKELP(data_selector, 0x22AD);

        // Are we being activated or de-activated?
        if (wParam)
        {
            // Make sure we're patching the correct code
            if ((lpPatch1[1] == 0x05)
            && (lpPatch1[2] == 0x00))
            {
                // Fix the segment and apply the patch
                GlobalFix ((HGLOBAL)code_selector);
                lpPatch1[1] = 0x0F;
                bFontPatched = TRUE;
            }
        }
        else
        {
            // If we previously made patch, un-apply it now
            if (bFontPatched)
            {
                // Un-apply the patch and un-fix the segment
                lpPatch1[1] = 0x05;
                GlobalUnfix ((HGLOBAL)code_selector);
                bFontPatched = FALSE;
            }
        }
    }

    // Free the selector we allocated, and we're done
    FreeSelector (data_selector);
    return 0;
}


