/*=====================================================
	CFileMap class header file.
	Written by: Mark Szamrej
	Date: November-1994
	Address: CompuServe 74261,1263

	Description: C++ class to facilitate the use of
	memory mapped files. Works with both disk files
	and shared memory. Class is safe in multithreaded
	and multitasking environments. Class cleanup will
	always be performed in the destructor.
=====================================================*/

#ifndef __FILE_MAP_H__
#define __FILE_MAP_H__

class CFileMap
{
//------------------ Member Functions ------------------
public:
			CFileMap();			// Standard constructor
	virtual	~CFileMap();		// Destructor

	virtual	BOOL 	MapFile(const char*, DWORD dwAccess= READ | WRITE);	// Map file to memory
	virtual	BOOL	MapMemory(const char*, DWORD dwBytes);				// Map shared memory
	virtual	LPVOID	Open(DWORD dwTimeOut= INFINITE);					// Open the file
	virtual	BOOL	Close();											// Release the file
	virtual	DWORD	GetLength(){return m_dwFileLen;}					// Length of this file
	virtual	void 	UnMapFile();										// Delete any mapping

protected:
	virtual	BOOL	MapHandle(const char*, HANDLE);						// Maps handle to memory

//------------------ Member Variables ------------------
public:
	enum{	READ = 0x0001,		// READ access
			WRITE = 0x0002,		// WRITE access
			};

protected:
	DWORD	m_dwAccess;			// Access type (Read and/or Write)
	DWORD	m_dwFileLen;		// Length of mapped file or memory

	LPVOID	m_lpBaseAddress;	// Address file is mapped to
	HANDLE	m_hMapping;			// File mapping handle
	HANDLE	m_hFile;			// File handle
	HANDLE	m_hMutex;			// Mutex to sync file access

	DWORD	m_dwOpen;			// Lock count of open object
};

#endif	// __FILE_MAP_H__



