/***********************************************************
  PROGRAM: Modeless.c
  AUTHOR:  Tony Yuricich
           CIS: 72350,3476
           INTERNET: usr8118a@tso.uc.edu
  PURPOSE:
     It demonstates how to work with multiple modeless
     dialog boxes.
***********************************************************/

#include <windows.h>
#include <windowsx.h>
#include "resource.h"

#if defined(_WIN32)
#define __export
#endif

void static Main_OnCommand( HWND hwnd, int id, HWND hwndCtl,
                                           UINT codeNotify);
HWND GetModelessHwnd( int TitleId);

#ifdef __WATCOMC__
     #pragma off (unreferenced);
#endif

HINSTANCE hInst;
HWND hAllModeless;
BOOL fWin32s = FALSE; /* assume not running on Win32s */

// The following 3 functions are a standard Windows stuff.

LRESULT CALLBACK __export MainWndProc(HWND hWnd,
                 UINT message, WPARAM wParam, LPARAM lParam)
{
    if(message == WM_COMMAND)
        HANDLE_WM_COMMAND(hWnd,wParam,lParam,Main_OnCommand);
    else if(message == WM_DESTROY)
        PostQuitMessage(0);
    else
        return DefWindowProc(hWnd, message, wParam, lParam);
    return 0;
}

BOOL InitApplication( HINSTANCE hInstance)
{
    WNDCLASS  wc;
    wc.style        = 0;
    wc.lpfnWndProc  = MainWndProc;
    wc.cbClsExtra   = wc.cbWndExtra = 0;
    wc.hInstance    = hInstance;
    wc.hIcon        = LoadIcon( NULL, IDI_APPLICATION);
    wc.hCursor      = LoadCursor( NULL, IDC_ARROW);
    wc.hbrBackground= (HBRUSH)( COLOR_WINDOW + 1);
    wc.lpszMenuName = "ModelessMenu";
    wc.lpszClassName= "GenericWClass";
    return (RegisterClass(&wc));
}

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow)
{
    HWND            hWnd;
    hInst = hInstance;
    /* Create a main window for this application instance.*/
    hWnd = CreateWindow(
        "GenericWClass", "Many modeless dialogs",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL,
        hInstance, NULL);
    if ( (HWND)0 == hWnd )
        return FALSE;
    ShowWindow( hWnd, nCmdShow);
    UpdateWindow( hWnd);
    return TRUE;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain( HINSTANCE hInstance,
     HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if ( hPrevInstance < (HINSTANCE)HINSTANCE_ERROR)
       if ( !InitApplication( hInstance))
          return FALSE;
    if ( !InitInstance(hInstance, nCmdShow))
        return FALSE;
    fWin32s = (BOOL) (GetVersion() & 0x80000000);
    while ( GetMessage( &msg, NULL, 0, 0))
    {
       // Apply IsDialogMessage() to just one window handle.
       if (!(IsWindow(hAllModeless) &&
                      IsDialogMessage( hAllModeless, &msg)))
          {
          TranslateMessage( &msg);
          DispatchMessage( &msg);
          }
    }
    return msg.wParam;
}

// 5 menu commands processed in function below
// create 5 modeless dialog boxes.

// NOTE:
// All 5 modeless dialog box procedures above use the following 3
// message processing functions.

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL static Modeless_OnInitDialog(HWND hwnd, HWND hwndFocus,
                                              LPARAM lParam)
{
   char Title[32];
// Load the title of the dialog from resources. We use the
// title to find the dialog handle with FindWindow() in
// GetModelessHwnd() below.
   if( LoadString( hInst, (int)lParam, Title, sizeof Title))
        SetWindowText( hwnd, Title);
   return TRUE;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
void static Modeless_OnActivate(HWND hwnd, UINT state,
                         HWND hwndActDeact, BOOL fMinimized)
{
   if ( state != WA_INACTIVE) // becoming active in some way
        hAllModeless = hwnd;  // set to active dialog handle
   else // ease work of main message pump
        hAllModeless = (HWND)0;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
void static Modeless_OnCommand(HWND hwnd, int id,
                              HWND hwndCtl, UINT codeNotify)
{
    switch ( id )
    {
       case IDOK:
       case IDCANCEL:
          if ( codeNotify == BN_CLICKED)
             DestroyWindow( hwnd);
          break;
    }
}

BOOL __export CALLBACK ModelessProc(HWND hDlg, UINT message,
                               WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG: /* message: initialize dialog box */
        return (BOOL)HANDLE_WM_INITDIALOG( hDlg, wParam,
                             lParam, Modeless_OnInitDialog);
    case WM_ACTIVATE:
        HANDLE_WM_ACTIVATE( hDlg, wParam, lParam,
                                       Modeless_OnActivate);
        break;
    case WM_COMMAND:   /* message: received a command */
        HANDLE_WM_COMMAND( hDlg, wParam, lParam,
                                        Modeless_OnCommand);
        break;
    }
    return FALSE;      /* Didn't process a message    */
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
void static Main_OnCommand( HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    HWND hModelessDlg;
    int  StrID;

    if(id >= IDM_MOD1 && id <= IDM_MOD5)
    {
         StrID = IDS_MODTITLE1 + (id-IDM_MOD1);
         if (!IsWindow(hModelessDlg=GetModelessHwnd(StrID)))
            hAllModeless = CreateDialogParam(hInst,
                    MAKEINTRESOURCE( IDD_MODELESSBOX), hwnd,
                                       ModelessProc, StrID);
         else
            SetFocus(hModelessDlg);
    }
}

// NOTE:
// This function is the reason for this sample application.
// It shows how to find the handle of the modeless dialog.
// If the NULL handle is returned, dialog does not exist.

HWND GetModelessHwnd( int TitleId)
{
   HWND hwnd;
   char Title[32];

   LoadString( hInst, TitleId, Title, sizeof Title);

   // 0x8002 is the dialog window class.
   hwnd = FindWindow( MAKEINTATOM(0x8002), Title);

    if ( (HWND)0 != hwnd
         &&
#if defined(_WIN32)
         GetWindowThreadProcessId( hwnd, NULL) !=
        GetCurrentThreadId()//for multiple processes/threads
#else
         // for multiple instances
         GetWindowTask( hwnd) != GetCurrentTask()
#endif
       )
       return (HWND)0;
   return hwnd;
}
