#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include "module.h"
#include "import.h"
#include "resource.h"

#define IDC_LISTBOX 201

HINSTANCE hAppInstance;
HWND hwndApp, hwndListBox;
char szAppClass[] = "CHKLIBClass";
char szAppTitle[] = "CHKLIB";

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
    MSG msg;
    WNDCLASS wndclass;

    hAppInstance = hInstance;
        
    if (!hPrevInstance) {
        wndclass.style = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(0, IDI_APPLICATION);
        wndclass.hCursor = LoadCursor(0, IDC_ARROW);
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
        wndclass.lpszClassName = szAppClass;
        RegisterClass(&wndclass);
    }
    
    hwndApp = CreateWindow(
        szAppClass,
        szAppTitle,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        (HWND)NULL,
        (HMENU)NULL,
        hInstance,
        (LPVOID)NULL);
    
    hwndListBox = CreateWindow(
        "LISTBOX",
        "",
        WS_CHILD|WS_VISIBLE|WS_VSCROLL|LBS_NOTIFY|
        LBS_SORT|LBS_USETABSTOPS|LBS_NOINTEGRALHEIGHT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        hwndApp,
        (HMENU)NULL,
        hInstance,
        (LPVOID)NULL);

    SetWindowWord(hwndListBox, GWW_ID, IDC_LISTBOX);
    ShowWindow(hwndApp, nCmdShow);
    UpdateWindow(hwndApp);

    while (GetMessage(&msg, (HWND)NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    
    return msg.wParam;
}

LPARAM EXPORT WndProc(hwnd, uMsg, wParam, lParam)
HWND hwnd;
UINT uMsg;
WPARAM wParam;
LPARAM lParam;
{
    RECT rect;
    static LPMODULE pModuleList;
    static char szModuleFile[256];
    
    switch (uMsg) {

    case WM_PAINT:
           GetClientRect(hwnd, &rect);
        SetWindowPos(hwndListBox, 0, 0, 0,
               rect.right, rect.bottom, SWP_NOZORDER);
        break;

    case WM_COMMAND:
        switch (wParam) {
        case IDM_EXIT:
            SendMessage(hwnd, WM_CLOSE, 0, 0L);
            return 0L;

        case IDM_OPENFILE:
            if (SelectFile(hwnd, szModuleFile,
                sizeof(szModuleFile)))
                PostMessage(hwnd, WM_USER, 0, 0L);
            return 0L;

        case IDC_LISTBOX:
            if (HIWORD(lParam) == LBN_DBLCLK) {
                DWORD dwIndex = SendMessage(hwndListBox,
                    LB_GETCURSEL, 0, 0L);
                if (dwIndex != (DWORD)LB_ERR) {
                    SendMessage(hwndListBox, LB_GETTEXT,
                        (WPARAM)dwIndex,
                        (LPARAM)((LPSTR)szModuleFile));
                    PostMessage(hwnd, WM_USER, 0, 0L);
                }
            }
            return 0L;
        }
        break;

    case WM_USER:
        {
        LPMODULE    lpModule;
           if (pModuleList) {
            FreeModuleList(pModuleList);
            pModuleList = (LPMODULE)NULL;
            SendMessage(hwndListBox, LB_RESETCONTENT, 0, 0L);
        }
        GetImportModules(&pModuleList, szModuleFile, ShowError);

        lpModule    = pModuleList;
        while (lpModule) {
            if (lpModule->fImported)
                SendMessage(hwndListBox, LB_ADDSTRING, 0,
                    (LPARAM)lpModule->szFile);
            lpModule = lpModule->pNext;
        }

        return 0L;    

        }
    case WM_DESTROY:
           if (pModuleList)
               FreeModuleList(pModuleList);
        PostQuitMessage(0);
        return 0L;
    }

    return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

int SelectFile(HWND hwnd, LPSTR pszFileName, int cbFileName)
{
    OPENFILENAME ofn;

    memset(&ofn, 0, sizeof(ofn));
    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = "Modules (*.exe;*.dll)\0*.exe;*.dll\0";
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = (LPSTR)pszFileName;
    ofn.nMaxFile = cbFileName;
    ofn.lpstrTitle = "Open Module File";
    ofn.Flags = OFN_FILEMUSTEXIST;
    *pszFileName = '\0';
    return GetOpenFileName(&ofn);
}

void CALLBACK ShowError(int nErr, LPSTR pszFileName)
{
    LPSTR pszBaseName;
    char szFormat[64], szMessage[128];

    pszBaseName = strrchr(pszFileName, '\\');
    if (pszBaseName)
        pszBaseName++;
    else
        pszBaseName = pszFileName;
    
    LoadString(hAppInstance, nErr, szFormat, 64);
    wsprintf(szMessage, szFormat, (LPSTR)pszBaseName);
    MessageBox(hwndApp, szMessage,
        szAppTitle, MB_OK|MB_ICONEXCLAMATION);
}
