/*
 *  passthru.c - program to pass files directly to Windows printer.
 *
 *  This file simply supplies the user interface. It uses a dialog
 *  box as the main window, which greatly simplifies things.
 */

#include "passthru.h"
#include "ctl3d.h"      // for Microsoft's new 3-D control look
#include <stdio.h>

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif


BOOL CALLBACK _export DlgProc(HWND, UINT, WPARAM, LPARAM);

HINSTANCE   ThisInstance;   // ubiquitous instance handle.
TPrinter    Printer;        // For talking to printer.

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE Me, HINSTANCE Previous,
		     LPSTR lpszCmdLine, int nCmdShow)
    {
    ThisInstance    = Me;
    Ctl3dRegister(ThisInstance);
    Ctl3dAutoSubclass(ThisInstance);
    DialogBox(ThisInstance, "PassThru", NULL, DlgProc);
    Ctl3dUnregister(ThisInstance);
    return 0;
    }

void    DisplayPrinter(TPrinter *Printer, HWND Dialog)
    {
    char    Device[128];
    char    Driver[128];
    char    Port[128];

    Printer->GetDevice(Device, sizeof(Device));
    Printer->GetDriver(Driver, sizeof(Driver));
    Printer->GetPort(Port, sizeof(Port));

    char    Message[256];
    sprintf(Message, "%s (%s) on %s", Device, Driver, Port);
    SetDlgItemText(Dialog, ID_CURRENTPRINTER_STATIC, Message);
    }

UINT LastMessage;

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK _export DlgProc(HWND Dialog, UINT Message,
                             WPARAM Param1, LPARAM Param2)
    {
    if(Message == WM_INITDIALOG)
        {
        DisplayPrinter(&Printer, Dialog);
        Ctl3dSubclassDlgEx(Dialog, CTL3D_ALL);
        return TRUE;
        }
    else if(Message == WM_COMMAND)
        if(Param1 == IDOK || Param1 == IDCANCEL) {
            EndDialog(Dialog, 0);
            return TRUE;
            }
        else if(Param1 == ID_PRINT_BUTTON)
            {
            char    Filename[128];
            Filename[0] = '\0'; // trust no one
            SendDlgItemMessage(Dialog, ID_FILENAME_EDIT,
                       WM_GETTEXT, (WPARAM)sizeof(Filename),
                                          (LPARAM)Filename);
            if(Filename[0] == '\0')
                MessageBox(Dialog, "Select a file first",
                             "PassThru", MB_OK|MB_ICONHAND);
            else
                {
                char    Port[64];
                HDC     PrinterContext = Printer.CreateDC();
                Printer.GetPort(Port, sizeof(Port));
                PrintFile(PrinterContext, Port, Dialog, Filename);
                DeleteDC(PrinterContext);
                }
            return TRUE;
            }
        else if(Param1 == ID_SELECTPRINTER_BUTTON)
            {
            Printer.SetupDialog(Dialog);
            DisplayPrinter(&Printer, Dialog);
            return TRUE;
            }
        else if(Param1 == ID_BROWSE_BUTTON)
            {
            char    Filename[128];
            Filename[0] = '\0'; // trust no one
            SendDlgItemMessage(Dialog, ID_FILENAME_EDIT,
                WM_GETTEXT, (WPARAM)sizeof(Filename), (LPARAM)Filename);
            if(SimpleGetOpenFileName(Dialog, Filename, sizeof(Filename)))
                SetDlgItemText(Dialog, ID_FILENAME_EDIT, Filename);
            return TRUE;
            }
    return FALSE;
    }


