#define GET_USER_ID     0x16
#define CREATE_JOB      0x68
#define START_JOB       0x69
#define GET_BINDERY_ID  0x35
#define SCAN_BINDERY    0x37

#define CONNECT_ID_TABLE   3
#define SERVER_NAME_TABLE  4
#define PRINT_QUEUE        3
#define SERVER_NAME_SIZE  48
#define CONNECT_INFO_SIZE 32

#define BANNER_MASK   0x8000
#define NOTIFY_MASK   0x1000
#define NOFORM_MASK   0x0800
#define DEFAULT_MASK  0x4400 

#define SWAPBYTES(x) ((x) << 8 | (x) >> 8)

extern unsigned char GetConnection(void);
extern char far *GetNetwareTable(int table);
extern int NetwareInterface(void far *requestBuffer,
                            void far *replyBuffer,
                            int functionCode);
extern void SetPreferredConnection(int Connection);

struct GetBinderyIDRequest {
  unsigned int  BufferLength;
  unsigned char RequestType;
  unsigned int  ObjectType;
  unsigned char NameLength;
  unsigned char ObjectName[48];
};

struct GetBinderyIDReply {
  unsigned int  BufferLength;
  unsigned long ObjectID;
  unsigned int  ObjectType;
  unsigned char ObjectName[48];
};

struct CreateJobRequest {
  unsigned int  BufferLength;
  unsigned char RequestType;
  unsigned long QueueID;
  unsigned char ClientStation;
  unsigned char TaskNumber;
  unsigned long ClientID;
  unsigned long TargetServer;
  unsigned char ExecutionTime[6];
  unsigned char EntryTime[6];
  unsigned int  JobNumber;
  unsigned int  JobType;
  unsigned char JobPosition;
  unsigned char JobFlags;
  unsigned char JobFileName[14];
  unsigned char JobFileHandle[6];
  unsigned char Server;
  unsigned char ServerTaskNumber;
  unsigned long ServerID;
  unsigned char Description[50];

  /* The following area varies by job type:
     What is shown only applies to print jobs. */

  unsigned char VersionNumber;
  unsigned char TabSize;
  unsigned int  Copies;
  unsigned int  Flags;
  unsigned int  MaxLines;
  unsigned int  MaxChars;
  unsigned char FormName[16];
  unsigned char Reserved[6];
  unsigned char Banner[13];
  unsigned char BannerFileName[13];
  unsigned char HeaderFileName[14];
  unsigned char Path[80];
};

struct CreateJobReply {
  unsigned int  BufferLength;
  unsigned char ClientStation;
  unsigned char ClientTaskNumber;
  unsigned long ClientID;
  unsigned long TargetServer;
  unsigned char ExecutionTime[6];
  unsigned char EntryTime[6];
  unsigned int  JobNumber;
  unsigned int  JobType;
  unsigned char JobPosition;
  unsigned char JobFlags;
  unsigned char JobFileName[14];
  unsigned char JobFileHandle[6];
  unsigned char Server;
  unsigned char ServerTaskNumber;
  unsigned long ServerID;
};

struct StartJobRequest {
  unsigned int  BufferLength;
  unsigned char RequestType;
  unsigned long QueueID;
  unsigned int  JobNumber;
};

struct StartJobReply {
  unsigned int BufferLength;
};

struct GetConnectionInfoRequest {
  unsigned int  BufferLength;
  unsigned char RequestType;
  unsigned char Connection;
};

struct GetConnectionInfoReply {
  unsigned int  BufferLength;
  unsigned long ObjectID;
  unsigned int  ObjectType;
  unsigned char ObjectName[48];
  unsigned char LoginTime[7];
  unsigned char Reserved;
};

struct ScanBinderyRequest {
  unsigned int  BufferLength;
  unsigned char RequestType;
  unsigned long LastObjectID;
  unsigned int  ObjectType;
  unsigned char NameLength;
  unsigned char ObjectName[48];
};


struct ScanBinderyReply {
  unsigned int  BufferLength;
  unsigned long ObjectID;
  unsigned int  ObjectType;
  unsigned char ObjectName[48];
  unsigned char ObjectFlag;
  unsigned char ObjectSecurity;
  unsigned char Properties;
};
