//  uart_chk.c - determine if given I/O address is a UART

#include  "uart.h"
#define   TRUE      1
#define   FALSE     0

unsigned uart_check(unsigned addr)
    {
    // certain bits must always be zero
    if ((inp(addr+IER) & 0xf0) != 0x00) return(FALSE);
    if ((inp(addr+IIR) & 0x30) != 0x00) return(FALSE);
    if ((inp(addr+MCR) & 0xe0) != 0x00) return(FALSE);
    // Reading LSR and TRB forces certain bits to zero
    inp(addr+LSR);		// clear OV,PA,FR,BR,RF
    inp(addr+TRB);		// clear data ready
    if ((inp(addr+LSR) & 0x9f) != 0x00) return(FALSE);
    // Reading MSR forces certain bits to zero
    inp(addr+MSR);		// clear CTS, DSR, RI, DCD
    if ((inp(addr+MSR) & 0x0f) != 0x00) return(FALSE);
    // IIR bit 0 should be 1, bits 4 & 5 should be 0
    if ((inp(addr+IIR) & 0x31) != 0x01) return(FALSE);
    // LSR bits 5 and 6 should be 1
    if ((inp(addr+LSR) & 0x60) != 0x60) return(FALSE);
    return(TRUE);
    }

