//        uart.h - include file for uart_ utility functions
//	    INS8250-B and compatible UARTs
#define   TRB       0       // transmit and receive buffer
#define   IER       1       // interrupt enable register
#define   IIR       2       // interrupt ID register
#define   FCR       2       // FIFO control register
#define   MCR       4       // modem control register
#define   LSR       5       // line status register
#define   MSR       6       // modem status register
#define   SCR       7       // scratch register
#define   MCR_OUT2  0x08    // enable UART interrupts via MCR
//        8259A programmable interrupt controller
#define   PIC_A0      0x20    // A0 address line
#define   PIC_A1      0x21    // A1 address line
#define   PIC_IRR     0x0a    // prepare to read pic IRR
#define   PIC_ISR     0x0b    // prepare to read pic ISR
#define   PIC_EOI     0x20    // end of interrupt command
//        other constant identifiers & macros
#define   TICKS     0x0000046c// 0000:046c BIOS tick counter
#define   IO_DELAY  _asm {jmp short $+2}
// function prototypes for uart_ utility functions
unsigned uart_check      (unsigned addr);
unsigned uart_type       (unsigned addr);
unsigned char uart_irq   (unsigned addr);
