/****************************************************************************
    V. Ramachandran 27th October, 1994.
    Complete code for handling status bar updation when the user scrolls 
    through menu items, including popups.
****************************************************************************/

#include "windows.h"
#include "commctrl.h"
#include "statusb.h"

HANDLE hInst;
HWND hWnd, hWndStatus;

/****************************************************************************/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                                LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
    if (!InitApplication(hInstance))
        return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return (msg.wParam);
}


/****************************************************************************/
BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0; 
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  MAKEINTRESOURCE (IDR_MENU1);
    wc.lpszClassName = "GenericWClass";

    return (RegisterClass(&wc));

}

/****************************************************************************/
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    hInst = hInstance;

    hWnd = CreateWindow(
        "GenericWClass",
        "Status Bar Updation for Popup menus",
        WS_OVERLAPPEDWINDOW,            // Window style.
        CW_USEDEFAULT,                  // x
        CW_USEDEFAULT,                  // y
        CW_USEDEFAULT,                  // cx
        CW_USEDEFAULT,                  // cy
        NULL,                           // Parent Handle
        NULL,                           // Menu or child id.
        hInstance,                      // hInstance
        NULL                            // NULL.
    );

    if (!hWnd)
        return (FALSE);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);       

     hWndStatus = CreateStatusWindow (WS_CHILD | WS_BORDER | WS_VISIBLE, 
                                        "", hWnd, ID_TOOLBAR);
     if (!hWndStatus)
        MessageBox (hWnd, "Could not create status bar.", NULL, 0);
    return (TRUE);           

}

/****************************************************************************/
long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam,
                                                LPARAM lParam)
{
   switch (message) {
        case WM_MENUSELECT:
            if (HandleMenuSelect (hWnd, message, wParam, lParam))
                return DefWindowProc (hWnd, message, wParam, lParam);
            break;

        case WM_DESTROY:
        PostQuitMessage(0);
        break;

        default:
        return DefWindowProc (hWnd, message, wParam, lParam);
    }
    return FALSE;
}

/****************************************************************************/
// Handles updation of the status bar.
// Calls: SetStatusBarText () - to set the text in the status bar.
// Calls: HandlePopupMenus1 (). See comments below.
// Returns: TRUE if a menu is being closed, and default processing is required.
// FALSE otherwise.
// Comments: HandlePopupMenus1 and HandlePopupMenus2 are two ways to handle 
// display of status bar messages for popup menus.
/****************************************************************************/

int HandleMenuSelect (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    WORD wHelpContextID;

    if ((LOWORD (lParam) == -1) &&      //  Means a menu is being closed.
                (HIWORD (lParam) == 0)) {
        SetStatusBarText (EMPTY_STRING);
        return TRUE;
    }
    if (LOWORD (lParam) & MF_SYSMENU) {     // System menu in play.
        SetStatusBarText (SYSTEM_MENU);
        return FALSE;
    }
    if (LOWORD (lParam) & MF_POPUP) {       // Popup menu.
        wHelpContextID = HandlePopupMenus1 (hWnd, message, wParam, lParam);
//      wHelpContextID = HandlePopupMenus2 (hWnd, message, wParam, lParam);
   }
    else {              // Normal menu item.
        if (LOWORD (lParam) & MF_SEPARATOR)
            SetStatusBarText (EMPTY_STRING);
        else {
            wHelpContextID = wParam;
            SetStatusBarText (wHelpContextID);
        }
    }
    return FALSE;
}

/****************************************************************************/
// HandlePopupMenus1
// Parameters: Same parameters as any Window Procedure.
// Returns FALSE to indicate that it has processed the message.
// Description:
// This uses the handle that comes as the wParam in the WM_MENUSELECT message
// and uses it to get the first menuitem under that popup. Compare the id
// with the list of ids that form the first menu item under a popup to get
// a handle on the popup that the user is currently at.
// Note:
// This function will need changes if your application removes or changes
// the first menu items of popups at run-time. The modification will involve
// more items to check for. However, this function will work for popups at
// any levels.
/****************************************************************************/

int HandlePopupMenus1 (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    WORD wHelpContextID = 0;
    HMENU hSubMenu = (HMENU)wParam;
   int nMenuID = GetMenuItemID (hSubMenu, 0);

    switch (nMenuID) {
        case ID_FILE_NEW:
            wHelpContextID = ID_FILE_POPUP;
            break;
        case ID_EDIT_UNDO:
            wHelpContextID = ID_EDIT_POPUP;
            break;
        case ID_VIEW_TOOLBAR:
            wHelpContextID = ID_VIEW_POPUP;
            break;
        case ID_WINDOW_NEW:
            wHelpContextID = ID_WINDOW_POPUP;
            break;
        case ID_HELP_ABOUT:
            wHelpContextID = ID_HELP_POPUP;
            break;
        // ....
        // Add more case statements here whenever you add more popups to the menu.
        default:
            // Should never come here.
            wHelpContextID = EMPTY_STRING;
            break;
    }
    SetStatusBarText (wHelpContextID);
    return FALSE;
}

/****************************************************************************/
// HandlePopupMenus2
// Parameters: Same parameters as any Window Procedure.
// Returns FALSE to indicate that it has processed the message.
// Description:
// This will work only if your application has top-level popups only. This runs
// through the list of top-level menus and gets the appropriate id. I have 
// chosen ids which correspond to the position of the popups to save another
// check. This is not necessary.
// Note:
// As mentioned above, this will not work if your menu has popups other than 
// the top level ones. However, if it does not have, this method is 
// advantageous since it does not involve adding more case statements and the
// like that have to be done in the previous step.
/****************************************************************************/

int HandlePopupMenus2 (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HMENU hSubMenu = (HMENU)wParam;
    HMENU hMenu = (HMENU) HIWORD (lParam); 
    int nMenuItemCount = GetMenuItemCount (hMenu);  // Get number of popups.
    int i;

    for (i = 0; i < nMenuItemCount; i++) 
        if (GetSubMenu (hMenu, i) == hSubMenu) 
            break;
    SetStatusBarText (i);
    return FALSE;
}

/****************************************************************************/
// SetStatusBarText
// Parameter: String Table id.
// This has been made into a separate function since it is most likely that
// every application will have different ways of drawing the status bar.
/****************************************************************************/

void SetStatusBarText (WORD wID)
{
    char szBuffer [144];
    szBuffer [0] = '\0';
    wsprintf (szBuffer, "wID is %d\n", wID);
    OutputDebugString (szBuffer);
    LoadString (hInst, wID, szBuffer, 144);
    SendMessage (hWndStatus, SB_SETTEXT, 0, (LONG)(LPSTR)szBuffer);
}

