// Jim Lawless
// 74217.531@compuserve.com
//
// This program will create a script for the MS-DOS
// DEBUG utility that will provide functionality
// similar to the Unix UUDECODE program.
//
// Syntax:
//    DBENCODE <input-binary-file> <output-text-script>
//
// Compile:
//    bcc dbencode.c
// 


#include <stdio.h>
#include <stdlib.h>

void prologue(void);
void epilogue(void);
void write_codes(void);


   // Input and output files
FILE *fin,*fout;

unsigned count,total=0;
unsigned char inbuf[3];
unsigned char outbuf[4];

   // 70 characters-per-line
int cpl=70;

   // Running count of the number of characters
   // that have been output
int chars_out=0;

   // Global reference to the input filename
char *name;


#define EOI (0x40+0x21+1)
void main(int argc,char **argv)
{
   if(argc < 3) {
       fprintf(stderr,
         "Usage: dbencode input-file output-file");
       exit(1);
   }       
   if((fin=fopen(argv[1],"rb"))==NULL) {
      fprintf(stderr,
         "Cannot open input file %s\n",argv[1]);
      exit(1);
   }
   if((fout=fopen(argv[2],"w"))==NULL) {
      fprintf(stderr,
         "Cannot open output file %s\n",argv[2]);
      exit(1);
   }

      // Provide global reference to input filename
   name=argv[1];

      // Write out initial stuff to script file
   prologue();


      // Now read file and translate groups of
      // characters.
   while(count=(fread(inbuf,1,3,fin))) {
      outbuf[0]=(inbuf[0]>>2)+0x21;
      outbuf[1]=((inbuf[0]&3)<<4)+(inbuf[1]>>4)+0x21;
      outbuf[2]=((inbuf[1]&0x0f)<<2)+(inbuf[2]>>6)+0x21;
      outbuf[3]=(inbuf[2]&0x3f)+0x21;
      write_codes();
      total+=count;
   }
       // Write clean-up text to script
   epilogue();

       // Close files
   fclose(fin);
   fclose(fout);

   exit(0);
}


void prologue(void)
{

      // Write out lines that will cause DEBUG to
      // place the assembly code at F000 ( F008
      // is the actual execution point ).
      // When executed, this little program will
      // decode the remainder of the text into
      // DEBUG's work buffer.

   fprintf(fout,"e F000  44 F0 4B F0 5D F0 6F F0"
      " 0E 1F 33 DB BF 00 01 B4\n");
   fprintf(fout,"e F010  0A BA 75 F0 CD 21 A0 77"
      " F0 3C 62 74 18 8A 0E 76\n");
   fprintf(fout,"e F020  F0 32 ED BE 77 F0 8A 04"
      " 3C 62 74 E3 E8 07 00 49\n");
   fprintf(fout,"e F030  E3 DD 46 EB F1 C3 51 2C"
      " 21 FF 97 00 F0 59 43 43\n");
   fprintf(fout,"e F040  83 E3 07 C3 D0 E0 D0 E0"
      " 88 05 C3 8A E0 B1 04 D2\n");
   fprintf(fout,"e F050  E8 08 05 8A C4 47 B1 04"
      " D2 E0 88 05 C3 8A E0 B1\n");
   fprintf(fout,"e F060  02 D2 E8 08 05 47 B1 06"
      " 8A C4 D2 E0 88 05 C3 24\n");
   fprintf(fout,"e F070  3F 08 05 47 C3 5A\n");

      // Change IP register to F008
   fprintf(fout,"rip\n");
   fprintf(fout,"f008\n");
      // Execute assembly code
   fprintf(fout,"g\n");
}

void epilogue(void)
{
      // If the current line is not terminated
      // with my special end-of-input character,
      // do so, now.
   if(chars_out)
      fprintf(fout,"%c\n",EOI);

      // Write end-of-input character as first
      // character in line to indicate the end.
   fprintf(fout,"%c\n",EOI);

      // Assembly code will now have halted,
      // returning us to DEBUG.

      // Tell DEBUG how much info we want to
      // write.
   fprintf(fout,"rcx\n");
   fprintf(fout,"%x\n",total);

      // Tell DEBUG the name of our output file
   fprintf(fout,"n %s\n",name);

      // Tell DEBUG to write the output file
   fprintf(fout,"w\n");
      // Finally, tell DEBUG to quit.
   fprintf(fout,"q\n");
}

   // Write out each code. 4 bytes are
   // always output. If extraneous bytes
   // are written, an attempt to decode
   // them will not be made.
void write_codes(void)
{
   int i;
   for(i=0;i<4;i++) {
      fprintf(fout,"%c",outbuf[i]);
      chars_out++;
      if(chars_out>=(cpl-1)) {
         fprintf(fout,"%c\n",EOI);
         chars_out=0;
      }
   }
}