; The purpose of this program is simply to 
; assemble some code at address F000h. The
; executable code needs to live at this
; address, leaving the area from 100h
; to EFFFh free as an output file buffer.
code            segment
                assume  cs:code,ds:code
main            proc    near
                org     0100h
begin:
; This jump is used for debugging purposes
; only. The code at F000- is extracted and
; has been placed in a DBENCODE.C in a 
; hex-dump form.
                jmp     start

; change the origin to F000h
                org     0F000h
; this address table is used to call a
; function depending on the enumerated
; state of the input. Input will consist of four
; characters. Each function represents how to process
; the character for the given state.
funclist        dw      func1
                dw      func2
                dw      func3
                dw      func4
; end-of-input character
; (space-char)+1 + our range (64/40h) + 1
EOI             equ     21h+40h+1


start:
                push    cs
                pop     ds
; use BX as an index (0-3) related to the
; enumerated input state.
                xor     bx,bx
; Use DI to point to output buffer
                mov     di,offset 100h

; read next line from standard input
; into MS-DOS formatted buffer "buff"
nextline:
                mov     ah,0ah
                mov     dx,offset buff
                int     21h
; is first character an EOI?
                mov     al,ds:[buff+2]
                cmp     al,EOI
; if so, we're done
                jz      done

; get the number of characters read into CX
                mov     cl,ds:[buff+1]
                xor     ch,ch

; point SI to the input buffer
                mov     si,offset buff+2

; loop through all input characters
looper:
; get next input character
                mov     al,ds:[si]
                cmp     al,EOI
; if we encounter EOI, read the next line
                jz      nextline

; otherwise send the value to the decoder
                call    sendcode

; decrement counter
                dec     cx
; if counter is zero, read the next line
                jcxz    nextline

; bump input buffer pointer
                inc     si

; resume loop
                jmp     looper

; we're done. quit.
done:
                ret

; this subroutine decodes each character, 
; reconstructing the input into the output
; buffer
sendcode        proc    near

; save CX. We'll need to use it for some
; shifting operations.
                push    cx

; normalize al to the range (0-3fh) inclusive
                sub     al,21h

; call appropriate function based on value in
; BX register.
                call    ds:[bx+offset funclist]

; restore CX
                pop     cx

; adjust function pointer BX
                inc     bx
                inc     bx
                and     bx,7   ; constrict to (0,2,4,6)

; return to caller
                ret
sendcode        endp


; handle first code
func1           proc    near
                shl     al,1
                shl     al,1
                mov     ds:[di],al
                ret
func1           endp

; handle second code
func2           proc    near
                mov     ah,al
                mov     cl,4
                shr     al,cl
                or      ds:[di],al
                mov     al,ah
                inc     di
                mov     cl,4
                shl     al,cl
                mov     ds:[di],al
                ret
func2           endp

; handle third code
func3           proc    near
                mov     ah,al
                mov     cl,2
                shr     al,cl
                or      ds:[di],al
                inc     di
                mov     cl,6
                mov     al,ah
                shl     al,cl
                mov     ds:[di],al
                ret
func3           endp

; handle fourth code
func4           proc    near
                and     al,3fh
                or      ds:[di],al
                inc     di
                ret
func4           endp

; excessively large work buffer. This
; buffer is formatted for DOS function 0ah.
; This function needs to know the maximum 
; number of characters allowed for input as
; byte 0. It uses the next byte as the number
; of bytes read. The remainder comprises the
; input record.
buff            db      90
                db      ?
                db      90 dup(?)

main            endp
code            ends
                end     begin
