/*
 * @OSF_FREE_COPYRIGHT@ and Copyright 1992 Transarc Corp.
 */

#include <stdio.h>
#include "timop.h"

#define MAX_RANDOM        (10*1000*1000)

#ifdef _HPUX_SOURCE
#define random 1000 * rand
#define srandom srand
#endif

void dce_err(char *_1, unsigned long _2);

int main(
    int                   argc,
    char                  *argv[])
{
    unsigned_char_t       *server_name;
    long                  rand_num;
    idl_long_int          span, server_status;
    unsigned32            status;
    rpc_binding_handle_t  bind_handle;
    rpc_ns_handle_t       import_context;
    uuid_t                obj_uuid;
    error_status_t        dce_status = rpc_s_ok;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s server_name\n", argv[0]);
        exit(1);
    }
    server_name = (unsigned_char_t *)argv[1];

    uuid_from_string(STR_UUID, &obj_uuid, &status);
    if (status != uuid_s_ok) {
            dce_err("uuid_from_string", status);
            exit(1);
    }

    /* CDS initialization */
    rpc_ns_binding_import_begin(rpc_c_ns_syntax_dce, server_name,
        timop_v0_0_c_ifspec, &obj_uuid, &import_context, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_ns_binding_import_begin", status);
        exit(1);
    }
    rpc_ns_binding_import_next(import_context, &bind_handle,
        &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_ns_binding_import_next", status);
        exit(1);
    }
    rpc_ns_binding_import_done(&import_context, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_ns_binding_import_done", status);
        exit(1);
    }

    /* Security initialization */
    rpc_binding_set_auth_info(bind_handle,
        (unsigned_char_t *)"tserver",
        rpc_c_protect_level_pkt_integ, rpc_c_authn_dce_secret,
        NULL, rpc_c_authz_name, &status);
    if (status != rpc_s_ok) {
        dce_err("rpc_binding_set_auth_info", status);
        exit(1);
    }

    /* DCE setup done - make some RPCs */
    srandom(time(NULL));
    printf("\n%8s   %8s\n", "Random #", "Microsec");

    while(1) {
        rand_num = random()%MAX_RANDOM;

        timop_getspan(bind_handle, (idl_long_int)rand_num, &span,
            &server_status, &dce_status);
        if (dce_status != rpc_s_ok) {
            dce_err("timop_getspan (DCE)", dce_status);
            break;
        }
        else if (server_status != rand_num) {
            dce_err("timop_getspan (server)", server_status);
            break;
        }

        printf("%8ld   %8ld\n", rand_num, (long)span);
    }
}
