#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nxtd.h>
#include <diag.h>

#include "netgraph.h"

/*
   for Borland, disable unused variable warning
*/

#ifdef __BORLANDC__
#pragma warn -aus
#endif

#ifdef _MSC_VER
#endif

IPXRequestStruct     HoldRequest;
IPXReplyStruct       HoldReply[DIAG_NODES];

AddrStruct  BridgeList[DIAG_NODES];
int         BridgeCount = 0;

BYTE        NodeList[DIAG_NODES][6];
int         NodeCount = 0;

int main(int argc, char **argv)
{							   
   int          retcode,
                graphType;
   WORD         querySocket = IPX_QUERY_SOCKET,
                socket;
   IPXAddress   ipxAddress;

   printf("NETGRAPH - Sample Diagnostics application\n");

   if ( argc < 2 )
      Usage( argv[0] );
   else
   {
      if ( stricmp( argv[1],"NETWORKS") == 0 )
         graphType = 0;
      else if ( stricmp(argv[1],"NODES") == 0 )
         graphType = 1;
      else
         Usage( argv[0] );
   }

   /* Make sure IPX is active and ok */
   if ( IPXInitialize() != 0 )
   {
      printf("IPX must be loaded for this program to run.\n");
      exit(1);
   }

   /* Begin by opening a socket to send from */
   socket = 0;
   retcode = IPXOpenSocket( (BYTE far *) &socket, SHORT_LIVED );
   if ( retcode )
   {
      printf("Error opening socket %X.  Error = %X.\n", socket, retcode );
      exit(1);
   }

   /* Use my network to begin with */
   IPXGetInternetworkAddress( (BYTE far *)&ipxAddress );

   /* all 0xFFs to broadcast */
   memset( ipxAddress.node, 0xFF, 6 );

   /* broadcast to the Diagnostics Socket (0456h) */
   memmove( ipxAddress.socket, &querySocket, 2 );

   if ( (retcode = DiagnosticsBroadcast(socket, &ipxAddress)) != 0 )
   {
      printf("Error broadcasting diagnostics request.  Error = %X.\n", retcode);
      exit(1);
   }

   switch( graphType )
   {
      case 0:
         PrintServersBridges( BridgeList );
         break;

        case 1:
         PrintNodes( NodeList );
         break;

      default:
         Usage( argv[0] );
    }

   IPXCloseSocket( socket );

   return (0);
}


void Usage( char * s )
{
   printf("Usage: %s [networks] [nodes]\n", s);
   exit (1);
}


void PrintServersBridges( AddrStruct far bridgeList[] )
{
   int   i,
		   ccode,
         networksPrinted = 0;

   printf( "\nFile Servers/Bridges\n");

   for ( i = 0; i < BridgeCount; i++ )
   {
		/* 
		   Call DiagnosticsFunction with element
		   in bridgeList[i].  This is already an
			AddrStruct, so we just use it
		*/
		ccode = DiagnosticsFunctions(&bridgeList[i]);
		PrintAddress( bridgeList[i].network, 4 );

      if (++networksPrinted % 6 == 0)
	     printf( "\n" );
	  else
	     printf("    ");
   }

   printf("\n%d networks found.\n", networksPrinted);
   return;
}


void PrintNodes( BYTE far nodeList[][6] )
{
   int   i,
			ccode,
         nodesPrinted = 0;
	IPXAddress ipxAddress;
	
	/*	Get our network for use later */
	IPXGetInternetworkAddress((BYTE far *)&ipxAddress);

   printf( "\nNodes\n");

   for ( i = 0; i < NodeCount; i++ )
   {
		/* 
		   DiagnosticsFunctions() needs network and node,
 			so copy in node address from nodeList[i]
 		*/
		memcpy(ipxAddress.node,nodeList[i],6);
		ccode = DiagnosticsFunctions((AddrStruct far *)&ipxAddress);

      PrintAddress( nodeList[i], 6 );
	  if (++nodesPrinted % 5 == 0)
	     printf( "\n" );
	  else
	     printf("    ");
   }

   printf("\n%d nodes found.\n", nodesPrinted);
   return;
}


int DiagnosticsBroadcast( WORD socket, IPXAddress far * ipxAddress )
{
   int   i,
         z,
         retries,
			time;
   WORD  ticks,
		 	newNodes = TRUE;
   static ECB    SendECB;
   static ECB    RcvECB[DIAG_NODES];

   /* Set up listening ECBs */
   for ( i = 0; i < DIAG_NODES; i++ )
   {
      SetupECB( &RcvECB[i], socket, (void far *)&HoldReply[i], sizeof( IPXReplyStruct ) );
      IPXListenForPacket( &RcvECB[i] );
   }

   /* Setup for Sending, packetType is 0, and  number of Exclusion is 0 */
   SetupECB( &SendECB, socket, (void far *)&HoldRequest, sizeof( IPXRequestStruct ) );

   HoldRequest.ipxHeader.packetType = 0;
	memset(&HoldRequest.exclusionList, 0x00, sizeof(ExclusionPacketStructure));
   HoldRequest.exclusionList.numberOfExclusions = 0;
   memmove( &HoldRequest.ipxHeader.destination, ipxAddress, sizeof(IPXAddress));

	/* get the address to start the packet on its way */
   IPXGetLocalTarget( (BYTE far*)ipxAddress, SendECB.immediateAddress, &time );

   /* Check list of ECBs and re-send MAX_RETRIES times to be sure    */
   /* all stations have responded               */
   retries = 0;

   while ( newNodes == TRUE && retries < MAX_RETRIES )
   {
		newNodes = FALSE;
      /* Send the IPX diagnostics request */
      IPXSendPacket( &SendECB );
      while ( SendECB.inUseFlag != 0 )
         IPXRelinquishControl();

      if ( SendECB.completionCode != 0 )
      {
         printf( "Error in IPX Send, completion code = %X ", SendECB.completionCode);
         return(1);
      }

      /* Wait 2 times the time given by IPXGetLocalTarget plus
         a half second between each retry (give all nodes a chance to respond) */
		/* IPXGetIntervalMarker returns a marker from IPX in ticks */

      ticks = IPXGetIntervalMarker();
      printf("Broadcasting Configuration Request...\n");

      do
      {

         for ( i = 0; i < DIAG_NODES; i++ )
         {
            /* If this Receive ECB has received a good packet */
            if ( RcvECB[i].inUseFlag == 0 && RcvECB[i].completionCode == 0 )
            {
               /* If this node has a shell_driver component, it isn't a bridge or file server */
               if ( FindComponentOffset( &HoldReply[i].componentCount,SHELL_DRIVER_COMPONENT ) != 0xff )
               {
                  if ( !InNodeList( HoldReply[i].ipxHeader.source.node ) )
						{
                     memmove(NodeList[NodeCount++],
								HoldReply[i].ipxHeader.source.node,6);
							newNodes = TRUE;
						}

                  if ( !InExceptionList( HoldReply[i].ipxHeader.source.node ) )
                     memmove(HoldRequest.exclusionList.structureArray[HoldRequest.exclusionList.numberOfExclusions++].nodeAddress,
                        HoldReply[i].ipxHeader.source.node, 6 );

               }

					/* likewise, if it has a bridge component, it isn't a workstation */
               if ( FindComponentOffset( &HoldReply[i].componentCount,BRIDGE_DRIVER_COMPONENT ) != 0xff )
               {
                  BridgeStruct far * bridgeStruct = (BridgeStruct far *)
                  	&HoldReply[i].componentType[HoldReply[i].componentCount];

                  for ( z = 0; z < bridgeStruct->numberOfNets; z++ )
                     if ( bridgeStruct->bridge[z].localNetworkType == 1
								 && !InBridgeList( &bridgeStruct->bridge[z] ) )
                        memmove(&BridgeList[BridgeCount++],
                           bridgeStruct->bridge[z].network, 10 );
               }

					/* give this ECB back to IPX to listen again */
               IPXListenForPacket( &RcvECB[i] );
            }
         }

			/* do for 2 * transmit time plus 1/2 second */
		} while ( ( IPXGetIntervalMarker() - ticks ) < (2*time + .5 * 18) );

      retries++;
   }

   return (0);
}


void PrintAddress( BYTE far byte[], int count )
{
   int i;

   for (i=0; i<count; i++)
      printf("%02X", byte[i]);
}

void SetupECB( ECB far *ecbPtr, WORD socket, void far *fragAddress, WORD size )
{
   /* Initialize the fields necessary for all of our ECB's */
	/* No ESR, the socket passed in, and one fragment */
   ecbPtr->ESRAddress = NULL;
   ecbPtr->inUseFlag = 0;
   ecbPtr->socketNumber = socket;
   ecbPtr->fragmentCount = 1;
   ecbPtr->fragmentDescriptor[0].address = fragAddress;
   ecbPtr->fragmentDescriptor[0].size = size;

}

/* InBridgeList
	determines whether the bridge in driverStruct is already
	in the BridgeList
*/
int InBridgeList( struct StructDriver far * driverStruct )
{
   int exclude;

   if ( BridgeCount >= DIAG_NODES ) 
   	return (1);

   for ( exclude = 0; exclude < BridgeCount; exclude++ )
      if ( memcmp(BridgeList[exclude].network, driverStruct->network, 4 ) == 0 )
      	return (1);

   return (0);
}


/* InNodeList
	determines whether node is already in the NodeList
*/
int InNodeList( BYTE far node[6] )
{
   int exclude;

	 if ( NodeCount >= DIAG_NODES )
	 	return (1);

   for ( exclude = 0; exclude < NodeCount; exclude++ )
   {
      if ( memcmp(NodeList[exclude],node, 6 ) == 0 )
			return (1);
   }

   return (0);
}


/*	InExceptionList
	determines whether node is already in the exceptionList
*/
int InExceptionList( BYTE far node[6] )
{
   int exclude;

	 if ( HoldRequest.exclusionList.numberOfExclusions >= DIAG_NODES )
	 	return (1);

   for ( exclude = 0; exclude < HoldRequest.exclusionList.numberOfExclusions; exclude++ )
      if ( memcmp(HoldRequest.exclusionList.structureArray[exclude].nodeAddress, node, 6 ) == 0)
	      return (1);
   return (0);
}
