#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nxtd.h>
#include <diag.h>

#include "netgraph.h"

/*
   For both compilers, disable suspicious pointer warning
   and unused variable warning
*/
#ifdef __BORLANDC__
#pragma warn -sus
#pragma warn -aus
#endif

#ifdef _MSC_VER
#pragma warning( disable: 4049 4101 )
#endif

/* 
	DiagnosticsFunctions()
	test harness for the diagnostic functions 
	calls appropriate functions for each component type
*/
int  DiagnosticsFunctions(AddrStruct far *Address)
{
	/* To save on stack space, declare a group of
	   pointers to structures, and then only use
		one buffer
	*/
	BeginDiagnosticStruct 		beginStruct,
										ptpBeginStruct;
	AllResponseData 				respData;
	IPXSPXVersion		  		   far *ipxSpxVer;
	IPXStatisticsStruct		   far *	ipxStats;
	SPXStatisticsStruct		   far *	spxStats;
	BridgeDriverStatusStruct   far *	bridgeDriveStatus;
	DriverConfigurationStruct  far *	driveConfig;
	DriverStatisticsStruct	 	far *	driveStats;
	OSVersionStruct			 	far *	osVersion;
	PrimaryServerStruct		 	far *	primaryServer;
	ServerAddressTableStruct 	far *	serverAddress;
	ServerNameTableStruct	 	far *	serverName;
	ShellAddressStruct		 	far *	shellAddress;
	ShellStatisticsStruct	 	far *	shellStats;
	ShellVersionStruct		 	far *	shellVersion;
	AllKnownNetworksStruct	 	far *	knownNetworks;
	AllKnownServersStruct	 	far *	knownServers;
	BridgeStatisticsStruct	 	far *	bridgeStats;
	LocalTablesStruct			 	far *	localTables;
	StartCountingPacketsStruct			startPackets;
   SendPacketsResponseStruct  		sendPackets;
	SendPacketsRequestStruct			sendPacketsReq;
	SendPacketsResponseStruct			sendPacketsResp;
	ReturnReceivedPacketStruct			receivePackets;

	WORD		connID,
		 		ptpConnID,
		 		ticks,
		 		timeTicks,
		 		networkNum = 0,
		 		serverNum = 0;
	BYTE		buffer[MAX_IPX_PACKET_SIZE],
		 		componentList[54],
		 		ptpComponentList[54],
		 		compNum,
		 		boardNum = 0;
	int 		ccode,
		 		transTime;

	/* Copy Address to our BeginDiagnosticsStruct 
		and then call BeginDiagnostics() */
	memcpy( (BYTE far *)&beginStruct, (BYTE far *)Address, sizeof(AddrStruct));
	ccode = BeginDiagnostics( &beginStruct, &connID, componentList );

	if (ccode)
		return (ccode);
	
	/* the componentlist consists of number of entries in 0th position
	   then the component types in the 1-nth positions */
	for ( compNum=0; compNum < componentList[0]; compNum++)
	{
		switch( componentList[compNum+1])
		{
			/* Call appropriate functions for each component type */ 
			case IPX_SPX_COMPONENT:
				ipxSpxVer = buffer;
				ccode = GetIPXSPXVersion( connID, compNum, &respData, ipxSpxVer);

				ipxStats = buffer;
				ccode = GetIPXStatistics( connID, compNum, &respData, ipxStats);

				spxStats = buffer;
				ccode = GetSPXStatistics( connID, compNum, &respData, spxStats);

				#ifdef POINT_TO_POINT
				/* 
				   Point to point testing can take a long time
					only do if defined POINT_TO_POINT
				*/
				ccode = StartCountingPkts( connID, compNum, &respData, &startPackets);
				EndDiagnostics( connID );

				ticks = 18;
    			sendPacketsReq.target = ptpBeginStruct;
				*(WORD*)sendPacketsReq.target.socket = startPackets.destinationSocket;
    			IPXGetLocalTarget(&sendPacketsReq.target,sendPacketsReq.immediateAddress,&transTime);
				sendPacketsReq.numberOfPackets = 250;
    			sendPacketsReq.timerTickInterval = 3;
    			sendPacketsReq.packetsPerTickInterval = 5;
    			sendPacketsReq.packetSize = 30;
    			sendPacketsReq.changeSize = 5;
				ccode = BeginDiagnostics( &ptpBeginStruct, &ptpConnID, ptpComponentList );

				ccode = StartSendingPktsTimed( ptpConnID, compNum, &sendPacketsReq, &respData, &sendPacketsResp, ticks);
				EndDiagnostics( ptpConnID );

				ccode = BeginDiagnostics( &beginStruct, &connID, componentList );

				timeTicks = IPXGetIntervalMarker();
				while ( (IPXGetIntervalMarker() - timeTicks) < ticks)
					IPXRelinquishControl();

				ccode = ReturnReceivedPacketCount( connID, compNum, &respData, &receivePackets);

				#endif /* POINT_TO_POINT

				/* 
					AbortSendingPackets should be used to cancel a test before
				   the alloted time, but for now, just give example
				*/
				/*
				ccode = AbortSendingPackets( connID, compNum);
				*/
				break;

			case BRIDGE_DRIVER_COMPONENT:
				driveConfig = buffer;
				ccode = GetBridgeDriverConfiguration( connID, compNum, boardNum, &respData, driveConfig);
				
				driveStats = buffer;
				ccode = GetBridgeDriverStatistics( connID, compNum, boardNum, &respData, driveStats);
				
				bridgeDriveStatus = buffer;
				ccode = GetBridgeDriverStatus( connID, compNum, &respData, bridgeDriveStatus);
				break;

			case SHELL_DRIVER_COMPONENT:
				driveConfig = buffer;
				ccode = GetShellDriverConfiguration(connID, compNum, &respData, driveConfig);

				driveStats = buffer;
				ccode = GetShellDriverStatistics(connID, compNum, &respData, driveStats);
				break;

			case SHELL_COMPONENT:
			case VAP_SHELL_COMPONENT:
				osVersion = buffer;
				ccode = GetOSVersionInfo(connID, compNum, &respData, osVersion);

				primaryServer = buffer;
				ccode = GetPrimaryServerNumber(connID, compNum, &respData, primaryServer);

				serverAddress = buffer;
				ccode = GetServerAddressTable(connID, compNum, &respData, serverAddress);

				serverName = buffer;
				ccode = GetServerNameTable(connID, compNum, &respData, serverName);

				shellAddress = buffer;
				ccode = GetShellAddress(connID, compNum, &respData, shellAddress);

				shellStats = buffer;
				ccode = GetShellStatistics(connID, compNum, &respData, shellStats);

				shellVersion = buffer;
				ccode = GetShellVersionInfo(connID, compNum, &respData, shellVersion);
				break;

			case BRIDGE_COMPONENT:
			case FILE_SERVER_COMPONENT:
			case NONDEDICATED_IPX_SPX_COMPONENT:
				bridgeStats = buffer;
				ccode = GetBridgeStatistics(connID, compNum, &respData, bridgeStats);

				#ifdef ROUTER_SAP
				/* 
				   dumping router and SAP can take a long time
					only do if defined ROUTER_SAP
				*/

				knownNetworks = buffer;					
				do 
				{
					BYTE i;
					SpecificNetworkInfoStruct specificNetwork;
					
					ccode = GetAllKnownNetworks(connID, compNum, networkNum, &respData, knownNetworks);
					for ( i=0; i < knownNetworks->numberOfNetworkAddresses; i++ )
						ccode = GetSpecificNetworkInfo(connID, compNum, &knownNetworks->networkAddress[i], &respData, &specificNetwork);
					networkNum += knownNetworks->numberOfNetworkAddresses;					
				} while ( !ccode && knownNetworks->numberOfNetworkAddresses == 128 );
				/* continue to loop until GetAllKnownNetworks returns less than 128 entries */

				knownServers = buffer;
				do 
				{
					BYTE i;
					SpecificServerInfoStruct specificServer;

					ccode = GetAllKnownServers(connID, compNum, 0, &respData, knownServers);
					for( i=0; i < knownServers->numberOfServers; i++ )
						ccode = GetSpecificServerInfo(connID, compNum, &knownServers->serverInfo[i], &respData, &specificServer);
					serverNum += knownServers->numberOfServers;
				} while ( !ccode && knownServers->numberOfServers == 10 );
				/* continue to loop until GetAllKnownServers returns less than 10 entries */

				#endif /* ROUTER_SAP */
				break;

		} /* End switch statement */
	} /* End	for statement */

	EndDiagnostics( connID );
	return (ccode);
}

