#include <windows.h>
#include <malloc.h>
#include <stdio.h>
#include <process.h>

BOOL EnableTakeOwnershipPrivilege( 
    HANDLE TokenHandle,
    PTOKEN_PRIVILEGES OldPrivileges
    );

BOOL OpenToken(
    PHANDLE TokenHandle
    );

VOID _CRTAPI1 main  (int argc, char *argv[])
{
    int i;
    PACL Dacl;
    LPSTR FileName;
    TOKEN_PRIVILEGES OldPrivileges;
    SID_IDENTIFIER_AUTHORITY NtAuthority = SECURITY_NT_AUTHORITY;
    PSID AdminAliasSid;
    BOOL Result;
    ULONG DaclSize;
    HANDLE TokenHandle;
    SECURITY_DESCRIPTOR SecurityDescriptor;

    if ( argc <= 1 ) {

        printf("No file specified\n");
        exit(-1);
    }

    Result = AllocateAndInitializeSid(
                 &NtAuthority,    2,
                 SECURITY_BUILTIN_DOMAIN_RID,
                 DOMAIN_ALIAS_RID_ADMINS,
                 0, 0, 0, 0, 0, 0,
                 &AdminAliasSid
                 );

    if ( !Result ) {
        printf("Unable to allocate memory for SIDs\n");
        exit(-1);
    }

    Result = OpenToken( &TokenHandle );

    if ( !Result ) {
        printf("Unable to open token\n");
        exit(-1);
    }

    // Built the new Security Descriptor to put on
    // the file.
    // This will only fail if the revision is wrong, but
    // it's good to be prepared for anything.

    Result = InitializeSecurityDescriptor( &SecurityDescriptor, SECURITY_DESCRIPTOR_REVISION );

    if ( !Result ) {
        printf("Unable to initialize Security Descriptor\n");
        exit(-1);
    }

    // Compute the size of the buffer needed for the 
    // DACL.

    DaclSize = sizeof( ACL )                + 
               sizeof( ACCESS_ALLOWED_ACE ) -
               sizeof( ULONG )              +
               GetLengthSid( AdminAliasSid );
               
    Dacl = malloc( DaclSize );

    if ( Dacl == NULL ) {
        printf("Out of memory\n");
        exit(-1);
    }

    Result =  InitializeAcl ( Dacl, DaclSize, ACL_REVISION2 );

    if ( !Result ) {
        printf("Unable to initialize ACL, error = %d\n",GetLastError());
        exit(-1);
    }

    Result = AddAccessAllowedAce ( 
                 Dacl,             
                 ACL_REVISION2,    
                 GENERIC_ALL,      
                 AdminAliasSid     
                 );

    if ( !Result ) {
        printf("Unable to add ACE, error = %d\n",GetLastError());
        exit(-1);
    }

    Result = SetSecurityDescriptorDacl (                   
                 &SecurityDescriptor, 
                 TRUE,
                 Dacl,
                 FALSE
                 );

    if ( !Result ) {
        printf("Unable to add ACL to security descriptor, error = %d\n",GetLastError());
        exit(-1);
    }

    Result = SetSecurityDescriptorOwner(
                 &SecurityDescriptor,
                 AdminAliasSid, FALSE
                 );

    if ( !Result ) {
        printf("Unable to set owner, error = %d\n",GetLastError());
        exit(-1);
    }
                
    for (i=1; i<argc; i++) {
        FileName = argv[i];
        printf("\nFile: %s\n",FileName);
        Result = SetFileSecurity(
                     FileName,
                     DACL_SECURITY_INFORMATION,
                     &SecurityDescriptor
                     );
        if ( Result ) {
            printf("%s: Dacl replaced\n",FileName);
            continue;
        }

        // If the attempt to change the DACL didn't work,
        // we have to make Admin the owner.  Just try it
        // first, and then try it with a privilege.

        Result = SetFileSecurity(
                     FileName,
                     OWNER_SECURITY_INFORMATION,
                     &SecurityDescriptor
                     );
        if ( !Result ) {
            // The attempt to make Admin the owner of
            // the file failed.  Use SeTakeOwnership
            // privilege.
            Result = EnableTakeOwnershipPrivilege( 
                        TokenHandle, 
                        &OldPrivileges 
                        );
            if ( !Result ) {
                // This account doesn't have SeTakeOwnership
                // privilege.  Tell them to try running it again
                // from an account that does.

                printf("Unable to enable SeTakeOwnership privilege\n");
                printf("Try running take again from the Administrator account\n");
                printf("%s: skipped\n",FileName);
                continue;
            }
            Result = SetFileSecurity(
                         FileName,
                         OWNER_SECURITY_INFORMATION,
                         &SecurityDescriptor
                         );
            if ( !Result ) {
                // This shouldn't fail, but it can.
                printf("Unable to set file owner with privilege\n");
                printf("Terminating\n");
                exit(-1);
            }

            // Turn off SeTakeOwnership privilege.
            (VOID) AdjustTokenPrivileges (
                        TokenHandle,
                        FALSE,
                        &OldPrivileges,
                        sizeof( TOKEN_PRIVILEGES ),
                        NULL,
                        NULL
                        );
            if ( GetLastError() != NO_ERROR ) {
                // This is unlikely to happen,
                printf("AdjustTokenPrivileges failed turning off SeTakeOwnership privilege\n");
            }
            Result = SetFileSecurity(
                         FileName,
                         DACL_SECURITY_INFORMATION,
                         &SecurityDescriptor
                         );
            if ( Result ) {
                printf("%s: Dacl replaced\n",FileName);
                continue;

            } else {
                // This shouldn't fail, but it can.
                printf("Unable to set DACL of file owned by Admin\n");
                printf("Terminating\n");
                exit(-1);
            }
        }
    }                      
}   

BOOL EnableTakeOwnershipPrivilege( HANDLE TokenHandle,
    PTOKEN_PRIVILEGES OldPrivileges )
{
    TOKEN_PRIVILEGES NewPrivileges;
    BOOL Result;
    LUID TakeOwnershipValue;
    ULONG ReturnLength;

    Result = LookupPrivilegeValue(
                 NULL, "SeTakeOwnershipPrivilege",
                 &TakeOwnershipValue
                 );
    if ( !Result ) {
        printf("Unable to obtain value of TakeOwnership privilege\n");
        return FALSE;
    }

    // Set up the privilege set we will need
    NewPrivileges.PrivilegeCount = 1;
    NewPrivileges.Privileges[0].Luid = TakeOwnershipValue;
    NewPrivileges.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

    (VOID) AdjustTokenPrivileges (
                TokenHandle, FALSE,
                &NewPrivileges,
                sizeof( TOKEN_PRIVILEGES ),
                OldPrivileges, &ReturnLength
                );
    if ( GetLastError() != NO_ERROR )
        return( FALSE );
    else
        return( TRUE );
}

BOOL OpenToken( PHANDLE TokenHandle )
{
    HANDLE Process;
    BOOL Result;

    Process = OpenProcess(
                PROCESS_QUERY_INFORMATION,
                FALSE, GetCurrentProcessId()
                );
    if ( Process == NULL ) {
        // This can happen, but is unlikely.
        return( FALSE );
    }

    Result = OpenProcessToken (
                 Process,
                 TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
                 TokenHandle
                 );
    CloseHandle( Process );
    if ( !Result ) {
        // This can happen, but is unlikely.
        return( FALSE );
    }
    return( TRUE );
}
    
