/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.resource;

import io.kotest.matchers.ComparableMatcherResult;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.resource.StringMatchersKt;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a6\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0004\u001a6\u0010\u000f\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0004\u001a6\u0010\u0010\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\f\u0010\u0011\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0001*\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"getActualFilePath", "Ljava/nio/file/Path;", "expectedFileURL", "Ljava/net/URL;", "getResource", "path", "", "matchResource", "Lio/kotest/matchers/Matcher;", "resourcePath", "matcherProvider", "Lkotlin/Function1;", "ignoreLineSeparators", "", "resourceAsString", "shouldMatchResource", "shouldNotMatchResource", "toLF", "writeToActualValueFile", "resourceUrl", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nstringMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stringMatchers.kt\nio/kotest/matchers/resource/StringMatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class StringMatchersKt {
    @NotNull
    public static final String shouldMatchResource(@NotNull String $this$shouldMatchResource, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldMatchResource, StringMatchersKt.matchResource(path, (Function1<? super String, ? extends Matcher<? super String>>)((Function1)shouldMatchResource.1.INSTANCE), true));
        return $this$shouldMatchResource;
    }

    @NotNull
    public static final String shouldNotMatchResource(@NotNull String $this$shouldNotMatchResource, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotMatchResource, StringMatchersKt.matchResource(path, (Function1<? super String, ? extends Matcher<? super String>>)((Function1)shouldNotMatchResource.1.INSTANCE), true));
        return $this$shouldNotMatchResource;
    }

    @NotNull
    public static final String shouldMatchResource(@NotNull String $this$shouldMatchResource, @NotNull String path, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        ShouldKt.should((Object)$this$shouldMatchResource, StringMatchersKt.matchResource(path, matcherProvider, ignoreLineSeparators));
        return $this$shouldMatchResource;
    }

    public static /* synthetic */ String shouldMatchResource$default(String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return StringMatchersKt.shouldMatchResource(string, string2, (Function1<? super String, ? extends Matcher<? super String>>)function1, bl);
    }

    @NotNull
    public static final String shouldNotMatchResource(@NotNull String $this$shouldNotMatchResource, @NotNull String path, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        ShouldKt.shouldNot((Object)$this$shouldNotMatchResource, StringMatchersKt.matchResource(path, matcherProvider, ignoreLineSeparators));
        return $this$shouldNotMatchResource;
    }

    public static /* synthetic */ String shouldNotMatchResource$default(String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return StringMatchersKt.shouldNotMatchResource(string, string2, (Function1<? super String, ? extends Matcher<? super String>>)function1, bl);
    }

    @NotNull
    public static final Matcher<String> matchResource(@NotNull String resourcePath, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        return (Matcher)new Matcher<String>(resourcePath, ignoreLineSeparators, matcherProvider){
            final /* synthetic */ String $resourcePath;
            final /* synthetic */ boolean $ignoreLineSeparators;
            final /* synthetic */ Function1<String, Matcher<String>> $matcherProvider;
            {
                this.$resourcePath = $resourcePath;
                this.$ignoreLineSeparators = $ignoreLineSeparators;
                this.$matcherProvider = $matcherProvider;
            }

            @NotNull
            public MatcherResult test(@NotNull String value) {
                URL resource;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                URL uRL = resource = StringMatchersKt.getResource(this.$resourcePath);
                Charset charset = Charsets.UTF_8;
                Object object = TextStreamsKt.readBytes((URL)uRL);
                String resourceValue = new String((byte[])object, charset);
                String normalizedValue = this.$ignoreLineSeparators ? StringMatchersKt.access$toLF(value) : value;
                String normalizedResourceValue = this.$ignoreLineSeparators ? StringMatchersKt.access$toLF(resourceValue) : resourceValue;
                object = ((Matcher)this.$matcherProvider.invoke((Object)normalizedResourceValue)).test((Object)normalizedValue);
                String string = this.$resourcePath;
                Object it = object;
                boolean bl = false;
                return (MatcherResult)ComparableMatcherResult.Companion.invoke(it.passed(), (Function0)new Function0<String>(normalizedValue, resource, (MatcherResult)it, string){
                    final /* synthetic */ String $normalizedValue;
                    final /* synthetic */ URL $resource;
                    final /* synthetic */ MatcherResult $it;
                    final /* synthetic */ String $resourcePath;
                    {
                        this.$normalizedValue = $normalizedValue;
                        this.$resource = $resource;
                        this.$it = $it;
                        this.$resourcePath = $resourcePath;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        Path actualFilePath = StringMatchersKt.access$writeToActualValueFile(this.$normalizedValue, this.$resource);
                        return this.$it.failureMessage() + "\n\nexpected to match resource, but they differed\nExpected : " + this.$resourcePath + "\nActual   : " + actualFilePath + "\n\n";
                    }
                }, (Function0)new Function0<String>((MatcherResult)it, string){
                    final /* synthetic */ MatcherResult $it;
                    final /* synthetic */ String $resourcePath;
                    {
                        this.$it = $it;
                        this.$resourcePath = $resourcePath;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$it.negatedFailureMessage() + "\n\nexpected not to match resource, but they match\nExpected : " + this.$resourcePath + "\n\n";
                    }
                }, normalizedValue, normalizedResourceValue);
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, String> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, String> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final String resourceAsString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = StringMatchersKt.getResource(path);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return new String(byArray, charset);
    }

    @NotNull
    public static final URL getResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = new Object(){}.getClass().getResource(path);
        if (uRL == null) {
            throw new IllegalStateException(("Failed to get resource at " + path).toString());
        }
        return uRL;
    }

    private static final Path writeToActualValueFile(String $this$writeToActualValueFile, URL resourceUrl) {
        Path path;
        Path $this$writeToActualValueFile_u24lambda_u240 = path = StringMatchersKt.getActualFilePath(resourceUrl);
        boolean bl = false;
        PathsKt.writeText$default((Path)$this$writeToActualValueFile_u24lambda_u240, (CharSequence)String.valueOf($this$writeToActualValueFile), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return path;
    }

    @NotNull
    public static final Path getActualFilePath(@NotNull URL expectedFileURL) {
        Intrinsics.checkNotNullParameter((Object)expectedFileURL, (String)"expectedFileURL");
        File expectedFile = new File(expectedFileURL.toURI());
        boolean bl = false;
        Path path = expectedFile.toPath().getParent().resolve("_actual");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"expectedFile.toPath()\n  \u2026      .resolve(\"_actual\")");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(this, *attributes)");
        Path path4 = path3.resolve(expectedFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"File(expectedFileURL.toU\u2026e(expectedFile.name)\n   }");
        return path4;
    }

    private static final String toLF(String $this$toLF) {
        CharSequence charSequence = $this$toLF;
        Regex regex = new Regex("\\r\\n?");
        String string = "\n";
        return regex.replace(charSequence, string);
    }

    public static final /* synthetic */ String access$toLF(String $receiver) {
        return StringMatchersKt.toLF($receiver);
    }

    public static final /* synthetic */ Path access$writeToActualValueFile(String $receiver, URL resourceUrl) {
        return StringMatchersKt.writeToActualValueFile($receiver, resourceUrl);
    }
}

