/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static String getClassifier(Artifact artifact) {
        String classifier = artifact.getClassifier();
        if (classifier != null && classifier.length() == 0) {
            classifier = null;
        }
        return classifier;
    }

    public static Set<MavenProject> getProjectModules(MavenProject project, List<MavenProject> reactorProjects, boolean includeSubModules, Logger logger) throws IOException {
        int changed;
        Set<MavenProject> singleParentSet = Collections.singleton(project);
        LinkedHashSet<MavenProject> moduleCandidates = new LinkedHashSet<MavenProject>(reactorProjects);
        LinkedHashSet<MavenProject> modules = new LinkedHashSet<MavenProject>();
        modules.add(project);
        do {
            changed = 0;
            Iterator candidateIterator = moduleCandidates.iterator();
            block1: while (candidateIterator.hasNext()) {
                MavenProject moduleCandidate = (MavenProject)candidateIterator.next();
                if (moduleCandidate.getFile() == null) {
                    logger.warn("Cannot compute whether " + moduleCandidate.getId() + " is a module of: " + project.getId() + "; it does not have an associated POM file on the local filesystem.");
                    continue;
                }
                Set<MavenProject> currentPotentialParents = includeSubModules ? new LinkedHashSet<MavenProject>(modules) : singleParentSet;
                for (MavenProject potentialParent : currentPotentialParents) {
                    if (potentialParent.getFile() == null) {
                        logger.warn("Cannot use: " + moduleCandidate.getId() + " as a potential module-parent while computing the module set for: " + project.getId() + "; it does not have an associated POM file on the local filesystem.");
                        continue;
                    }
                    if (!ProjectUtils.projectContainsModule(potentialParent, moduleCandidate)) continue;
                    modules.add(moduleCandidate);
                    candidateIterator.remove();
                    ++changed;
                    continue block1;
                }
            }
        } while (changed != 0);
        modules.remove(project);
        return modules;
    }

    private static boolean projectContainsModule(MavenProject mainProject, MavenProject moduleProject) throws IOException {
        List modules = mainProject.getModules();
        File basedir = mainProject.getBasedir();
        File moduleFile = moduleProject.getFile().getCanonicalFile();
        File moduleBasedir = moduleProject.getBasedir();
        if (moduleBasedir == null && (moduleBasedir = moduleFile.getParentFile()) == null) {
            moduleBasedir = new File(".");
        }
        moduleBasedir = moduleBasedir.getCanonicalFile();
        for (String moduleSubpath : modules) {
            File moduleDir = new File(basedir, moduleSubpath).getCanonicalFile();
            if (!moduleDir.equals(moduleFile) && !moduleDir.equals(moduleBasedir)) continue;
            return true;
        }
        return false;
    }
}

