/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public abstract class UseLatestVersionsMojoBase
extends AbstractVersionsDependencyUpdaterMojo {
    public UseLatestVersionsMojoBase(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @SafeVarargs
    protected final void useLatestVersions(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, BiFunction<Dependency, ArtifactVersions, Optional<ArtifactVersion>> newestVersionProducer, ChangeRecord.ChangeKind changeKind, Predicate<Dependency> ... filters) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        for (Dependency dep : dependencies) {
            if (!Arrays.stream(filters).map(f -> f.test(dep)).reduce(Boolean::logicalAnd).orElse(true).booleanValue()) continue;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            DefaultArtifactVersion selectedVersion = new DefaultArtifactVersion(dep.getVersion());
            this.getLog().debug((CharSequence)("Selected version:" + selectedVersion));
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            Optional<ArtifactVersion> newestVer = newestVersionProducer.apply(dep, versions);
            if (!newestVer.isPresent()) continue;
            this.updateDependencyVersion(pom, dep, newestVer.get().toString(), changeKind);
        }
    }
}

