/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ContentHashJavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.InaccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ProtoBasedJavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularJavaClassSnapshot;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004*\u00020\u00022\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0000\u00a8\u0006\b"}, d2={"getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshot;", "getSupertypes", "", "classIdResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "incremental-compilation-impl"})
public final class ClasspathChangesComputerKt {
    @NotNull
    public static final ClassId getClassId(@NotNull ClassSnapshot $this$getClassId) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)$this$getClassId, (String)"<this>");
        ClassSnapshot classSnapshot = $this$getClassId;
        if (classSnapshot instanceof KotlinClassSnapshot) {
            classId = ((KotlinClassSnapshot)$this$getClassId).getClassInfo().getClassId();
        } else if (classSnapshot instanceof RegularJavaClassSnapshot) {
            classId = ((RegularJavaClassSnapshot)$this$getClassId).getClassId();
        } else if (classSnapshot instanceof ProtoBasedJavaClassSnapshot) {
            classId = ((ProtoBasedJavaClassSnapshot)$this$getClassId).getSerializedJavaClass().getClassId();
        } else {
            if (classSnapshot instanceof InaccessibleClassSnapshot ? true : classSnapshot instanceof ContentHashJavaClassSnapshot) {
                throw new IllegalStateException(("Unexpected type (it should have been handled earlier): " + $this$getClassId.getClass().getName()).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassId> getSupertypes(@NotNull ClassSnapshot $this$getSupertypes, @NotNull Function1<? super JvmClassName, ClassId> classIdResolver) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$getSupertypes, (String)"<this>");
        Intrinsics.checkNotNullParameter(classIdResolver, (String)"classIdResolver");
        ClassSnapshot classSnapshot = $this$getSupertypes;
        if (classSnapshot instanceof KotlinClassSnapshot) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((KotlinClassSnapshot)$this$getSupertypes).getSupertypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                JvmClassName it = (JvmClassName)element$iv$iv;
                boolean bl2 = false;
                if ((ClassId)classIdResolver.invoke((Object)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (classSnapshot instanceof RegularJavaClassSnapshot) {
            Iterable $this$mapNotNull$iv = ((RegularJavaClassSnapshot)$this$getSupertypes).getSupertypes();
            boolean $i$f$mapNotNull = false;
            Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                ClassId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                JvmClassName it = (JvmClassName)element$iv$iv;
                boolean bl4 = false;
                if ((ClassId)classIdResolver.invoke((Object)it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (classSnapshot instanceof ProtoBasedJavaClassSnapshot) {
            void $this$mapTo$iv$iv;
            ClassProtoData classProtoData = JavaClassesTrackerImplKt.toProtoData(((ProtoBasedJavaClassSnapshot)$this$getSupertypes).getSerializedJavaClass());
            ProtoBuf.Class proto = classProtoData.component1();
            NameResolver nameResolver2 = classProtoData.component2();
            ProtoBuf.TypeTable typeTable = proto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"proto.typeTable");
            Iterable $this$map$iv = ProtoTypeTableUtilKt.supertypes(proto, new TypeTable(typeTable));
            boolean $i$f$map = false;
            Iterable $this$forEach$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type bl = (ProtoBuf.Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(NameResolverUtilKt.getClassId(nameResolver2, it.getClassName()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            if (classSnapshot instanceof InaccessibleClassSnapshot ? true : classSnapshot instanceof ContentHashJavaClassSnapshot) {
                throw new IllegalStateException(("Unexpected type (it should have been handled earlier): " + $this$getSupertypes.getClass().getName()).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }
}

