/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.LocalPropertyAndCapturedWriteCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extended.UnusedChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "()V", "isLoopIterator", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "CfaVisitor", "PathAwareVariableStatusInfo", "ValueWritesWithoutReading", "VariableStatus", "VariableStatusInfo", "checkers"})
public final class UnusedChecker
extends FirControlFlowChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object2 = graph2.getDeclaration();
        if (object2 != null && (object2 = FirHelpersKt.getContainingClassSymbol((FirDeclaration)object2, context2.getSession())) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            Object $this$isLocal$iv = it;
            boolean $i$f$isLocal = false;
            object = !((FirClassLikeSymbol)$this$isLocal$iv).getClassId().isLocal() ? object3 : null;
        } else {
            object = null;
        }
        if (object != null) {
            return;
        }
        Set properties2 = (Set)LocalPropertyAndCapturedWriteCollector.Companion.collect(graph2).component1();
        if (properties2.isEmpty()) {
            return;
        }
        Map<CFGNode<?>, PathAwareVariableStatusInfo> data = new ValueWritesWithoutReading(context2.getSession(), properties2).getData(graph2);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Backward, new CfaVisitor(data, reporter, context2));
    }

    private final boolean isLoopIterator(FirPropertySymbol $this$isLoopIterator) {
        Object object = ((FirProperty)$this$isLoopIterator.getFir()).getInitializer();
        return Intrinsics.areEqual((Object)(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$CfaVisitor;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getData", "()Ljava/util/Map;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    public static final class CfaVisitor
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwareVariableStatusInfo> data;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final CheckerContext context;

        public CfaVisitor(@NotNull Map<CFGNode<?>, PathAwareVariableStatusInfo> data, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.data = data;
            this.reporter = reporter;
            this.context = context2;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwareVariableStatusInfo> getData() {
            return this.data;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(node.getFir().getCalleeReference());
            if (firBasedSymbol == null) {
                return;
            }
            FirBasedSymbol<?> variableSymbol = firBasedSymbol;
            PathAwareVariableStatusInfo pathAwareVariableStatusInfo = this.data.get(node);
            if (pathAwareVariableStatusInfo == null) {
                return;
            }
            PathAwareVariableStatusInfo dataPerNode = pathAwareVariableStatusInfo;
            for (VariableStatusInfo dataPerLabel : (ImmutableCollection)dataPerNode.values()) {
                VariableStatus data;
                if ((VariableStatus)((Object)((Map)dataPerLabel).get(variableSymbol)) == null || data != VariableStatus.ONLY_WRITTEN_NEVER_READ) continue;
                KtSourceElement source = node.getFir().getLValue().getSource();
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), (DiagnosticContext)this.context, null, 8, null);
                break;
            }
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol variableSymbol = node.getFir().getSymbol();
            if (node.getFir().getSource() == null) {
                return;
            }
            if (INSTANCE.isLoopIterator(variableSymbol)) {
                return;
            }
            PathAwareVariableStatusInfo pathAwareVariableStatusInfo = this.data.get(node);
            if (pathAwareVariableStatusInfo == null) {
                return;
            }
            PathAwareVariableStatusInfo dataPerNode = pathAwareVariableStatusInfo;
            for (VariableStatusInfo dataPerLabel : (ImmutableCollection)dataPerNode.values()) {
                VariableStatus data;
                KtSourceElement ktSourceElement;
                if ((VariableStatus)((Object)dataPerLabel.get((Object)variableSymbol)) == null) continue;
                FirPhaseManagerKt.ensureResolved(variableSymbol, FirResolvePhase.BODY_RESOLVE);
                FirProperty variable2 = (FirProperty)variableSymbol.getFir();
                KtSourceElement it = ktSourceElement = variable2.getSource();
                boolean bl = false;
                KtSourceElement ktSourceElement2 = it;
                KtSourceElement variableSource = !Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION) ? ktSourceElement : null;
                if (data == VariableStatus.UNUSED) {
                    FirExpression firExpression2 = node.getFir().getInitializer();
                    FirFunctionCall firFunctionCall = firExpression2 instanceof FirFunctionCall ? (FirFunctionCall)firExpression2 : null;
                    if (firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)variableSource, FirErrors.INSTANCE.getUNUSED_VARIABLE(), (DiagnosticContext)this.context, null, 8, null);
                    break;
                }
                if (data.isRedundantInit()) {
                    FirExpression firExpression3 = variable2.getInitializer();
                    KtSourceElement source = firExpression3 != null ? firExpression3.getSource() : null;
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), (DiagnosticContext)this.context, null, 8, null);
                    break;
                }
                if (data != VariableStatus.ONLY_WRITTEN_NEVER_READ) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)variableSource, FirErrors.INSTANCE.getVARIABLE_NEVER_READ(), (DiagnosticContext)this.context, null, 8, null);
                break;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "", "priority", "", "(Ljava/lang/String;II)V", "isRead", "", "()Z", "setRead", "(Z)V", "isRedundantInit", "setRedundantInit", "merge", "variableUseState", "READ", "WRITTEN_AFTER_READ", "ONLY_WRITTEN_NEVER_READ", "UNUSED", "checkers"})
    public static final class VariableStatus
    extends Enum<VariableStatus> {
        private final int priority;
        private boolean isRead;
        private boolean isRedundantInit;
        public static final /* enum */ VariableStatus READ = new VariableStatus(3);
        public static final /* enum */ VariableStatus WRITTEN_AFTER_READ = new VariableStatus(2);
        public static final /* enum */ VariableStatus ONLY_WRITTEN_NEVER_READ = new VariableStatus(1);
        public static final /* enum */ VariableStatus UNUSED = new VariableStatus(0);
        private static final /* synthetic */ VariableStatus[] $VALUES;

        private VariableStatus(int priority) {
            this.priority = priority;
        }

        public final boolean isRead() {
            return this.isRead;
        }

        public final void setRead(boolean bl) {
            this.isRead = bl;
        }

        public final boolean isRedundantInit() {
            return this.isRedundantInit;
        }

        public final void setRedundantInit(boolean bl) {
            this.isRedundantInit = bl;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final VariableStatus merge(@Nullable VariableStatus variableUseState) {
            it = var3_3 = (base = variableUseState == null || this.priority > variableUseState.priority ? this : variableUseState);
            $i$a$-also-UnusedChecker$VariableStatus$merge$1 = false;
            if (this.isRead) ** GOTO lbl-1000
            v0 = variableUseState;
            v1 = v0 != null ? v0.isRead : false;
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = it.isRead = false;
            }
            if (!this.isRedundantInit) ** GOTO lbl-1000
            v3 = variableUseState;
            v4 = v3 != null ? v3.isRedundantInit : false;
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            it.isRedundantInit = v5;
            return var3_3;
        }

        public static VariableStatus[] values() {
            return (VariableStatus[])$VALUES.clone();
        }

        public static VariableStatus valueOf(String value2) {
            return Enum.valueOf(VariableStatus.class, value2);
        }

        static {
            $VALUES = variableStatusArray = new VariableStatus[]{VariableStatus.READ, VariableStatus.WRITTEN_AFTER_READ, VariableStatus.ONLY_WRITTEN_NEVER_READ, VariableStatus.UNUSED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0016R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "map", "Lkotlinx/collections/immutable/PersistentMap;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "merge", "other", "Companion", "checkers"})
    public static final class VariableStatusInfo
    extends ControlFlowInfo<VariableStatusInfo, FirPropertySymbol, VariableStatus> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> constructor;
        @NotNull
        private final Function0<VariableStatusInfo> empty;
        @NotNull
        private static final VariableStatusInfo EMPTY = new VariableStatusInfo(null, 1, null);

        public VariableStatusInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends VariableStatus> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ VariableStatusInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<FirPropertySymbol, ? extends VariableStatus>, VariableStatusInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<VariableStatusInfo> getEmpty() {
            return this.empty;
        }

        @Override
        @NotNull
        public VariableStatusInfo merge(@NotNull VariableStatusInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            VariableStatusInfo result2 = this;
            for (FirPropertySymbol symbol2 : CollectionsKt.union((Iterable)this.keySet(), (Iterable)other.keySet())) {
                VariableStatus variableStatus;
                VariableStatus kind1;
                VariableStatus variableStatus2 = (VariableStatus)((Object)this.get((Object)symbol2));
                if (variableStatus2 == null) {
                    variableStatus2 = kind1 = VariableStatus.UNUSED;
                }
                if ((variableStatus = (VariableStatus)((Object)other.get((Object)symbol2))) == null) {
                    variableStatus = VariableStatus.UNUSED;
                }
                VariableStatus kind2 = variableStatus;
                VariableStatus variableStatus3 = kind1.merge(kind2);
                result2 = (VariableStatusInfo)result2.put(symbol2, (Object)variableStatus3);
            }
            return result2;
        }

        public VariableStatusInfo() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final VariableStatusInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatusInfo;", "map", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "Companion", "checkers"})
    public static final class PathAwareVariableStatusInfo
    extends PathAwareControlFlowInfo<PathAwareVariableStatusInfo, VariableStatusInfo> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<EdgeLabel, VariableStatusInfo>, PathAwareVariableStatusInfo> constructor;
        @NotNull
        private final Function0<PathAwareVariableStatusInfo> empty;
        @NotNull
        private static final PathAwareVariableStatusInfo EMPTY;

        public PathAwareVariableStatusInfo(@NotNull PersistentMap<EdgeLabel, VariableStatusInfo> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ PathAwareVariableStatusInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<EdgeLabel, VariableStatusInfo>, PathAwareVariableStatusInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<PathAwareVariableStatusInfo> getEmpty() {
            return this.empty;
        }

        public PathAwareVariableStatusInfo() {
            this(null, 1, null);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NormalPath.INSTANCE, (Object)VariableStatusInfo.Companion.getEMPTY())};
            EMPTY = new PathAwareVariableStatusInfo(ExtensionsKt.persistentMapOf(pairArray));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PathAwareVariableStatusInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u00030\u0001B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010JA\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0014\"\u00020\n2\u0016\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J.\u0010!\u001a\u00020\u00022\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010\"\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020#2\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J)\u0010$\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\u0014\"\u00020&H\u0002\u00a2\u0006\u0002\u0010'J*\u0010(\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020)2\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J*\u0010*\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020+2\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$ValueWritesWithoutReading;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Set;)V", "getData", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "update", "pathAwareInfo", "symbols", "", "updater", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$VariableStatus;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;[Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "visitAnnotation", "dataForNode", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitNode", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitQualifiedAccesses", "qualifiedAccesses", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;[Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;)Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$PathAwareVariableStatusInfo;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class ValueWritesWithoutReading
    extends ControlFlowGraphVisitor<PathAwareVariableStatusInfo, Collection<? extends Pair<? extends EdgeLabel, ? extends PathAwareVariableStatusInfo>>> {
        @NotNull
        private final FirSession session;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;

        public ValueWritesWithoutReading(@NotNull FirSession session2, @NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.session = session2;
            this.localProperties = localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwareVariableStatusInfo> getData(@NotNull ControlFlowGraph graph2) {
            Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
            return CfgTraverserKt.collectDataForNode$default(graph2, TraverseDirection.Backward, PathAwareVariableStatusInfo.Companion.getEMPTY(), this, false, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PathAwareVariableStatusInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareVariableStatusInfo>> data) {
            Object object;
            block9: {
                PathAwareVariableStatusInfo result2;
                block8: {
                    void $this$reduce$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (data.isEmpty()) {
                        return PathAwareVariableStatusInfo.Companion.getEMPTY();
                    }
                    Iterable $this$map$iv = data;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        EdgeLabel label = (EdgeLabel)pair.component1();
                        PathAwareVariableStatusInfo info = (PathAwareVariableStatusInfo)pair.component2();
                        collection.add((PathAwareVariableStatusInfo)info.applyLabel(node, label));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void p1;
                        PathAwareVariableStatusInfo $i$f$mapTo2 = (PathAwareVariableStatusInfo)iterator$iv.next();
                        PathAwareVariableStatusInfo p0 = (PathAwareVariableStatusInfo)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = (PathAwareVariableStatusInfo)p0.merge((PathAwareControlFlowInfo)p1);
                    }
                    result2 = (PathAwareVariableStatusInfo)accumulator$iv;
                    Object obj = node.getFir();
                    object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                    if (object == null || (object = object.getAnnotations()) == null) break block8;
                    Iterable $this$fold$iv = (Iterable)object;
                    boolean $i$f$fold = false;
                    PathAwareVariableStatusInfo accumulator$iv2 = result2;
                    for (Object element$iv : $this$fold$iv) {
                        void p1;
                        FirAnnotation bl = (FirAnnotation)element$iv;
                        PathAwareVariableStatusInfo p0 = accumulator$iv2;
                        boolean bl2 = false;
                        accumulator$iv2 = this.visitAnnotation(p0, (FirAnnotation)p1);
                    }
                    object = accumulator$iv2;
                    if (object != null) break block9;
                }
                object = result2;
            }
            return object;
        }

        @Override
        @NotNull
        public PathAwareVariableStatusInfo visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareVariableStatusInfo>> data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareVariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            KtSourceElement ktSourceElement = node.getFir().getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return dataForNode;
            }
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            FirPropertySymbol[] firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(node){
                final /* synthetic */ VariableDeclarationNode $node;
                {
                    this.$node = $node;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus prev) {
                    VariableStatus variableStatus;
                    VariableStatus variableStatus2 = prev;
                    switch (variableStatus2 == null ? -1 : visitVariableDeclarationNode.WhenMappings.$EnumSwitchMapping$0[variableStatus2.ordinal()]) {
                        case -1: {
                            variableStatus = VariableStatus.UNUSED;
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (this.$node.getFir().getInitializer() != null && prev.isRead()) {
                                prev.setRedundantInit(true);
                                variableStatus = prev;
                                break;
                            }
                            if (this.$node.getFir().getInitializer() != null) {
                                variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ;
                                break;
                            }
                            variableStatus = null;
                            break;
                        }
                        case 3: {
                            variableStatus = VariableStatus.READ;
                            break;
                        }
                        default: {
                            variableStatus = null;
                        }
                    }
                    return variableStatus;
                }
            }));
        }

        @Override
        @NotNull
        public PathAwareVariableStatusInfo visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareVariableStatusInfo>> data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareVariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(node.getFir().getLValue());
            FirPropertySymbol firPropertySymbol = firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
            if (firPropertySymbol == null) {
                return dataForNode;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            FirPropertySymbol[] firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(this, symbol2){
                final /* synthetic */ ValueWritesWithoutReading this$0;
                final /* synthetic */ FirPropertySymbol $symbol;
                {
                    this.this$0 = $receiver;
                    this.$symbol = $symbol;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus prev) {
                    VariableStatus toPut;
                    VariableStatus variableStatus;
                    if (!ValueWritesWithoutReading.access$getLocalProperties$p(this.this$0).contains(this.$symbol)) {
                        variableStatus = null;
                    } else if (prev == VariableStatus.READ) {
                        variableStatus = VariableStatus.WRITTEN_AFTER_READ;
                    } else if (prev == VariableStatus.WRITTEN_AFTER_READ) {
                        variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ;
                    } else {
                        VariableStatus variableStatus2 = prev;
                        if (variableStatus2 == null) {
                            variableStatus2 = VariableStatus.UNUSED;
                        }
                        variableStatus = VariableStatus.ONLY_WRITTEN_NEVER_READ.merge(variableStatus2);
                    }
                    if ((toPut = variableStatus) == null) {
                        return null;
                    }
                    VariableStatus variableStatus3 = prev;
                    toPut.setRead(variableStatus3 != null ? variableStatus3.isRead() : false);
                    return toPut;
                }
            }));
        }

        @Override
        @NotNull
        public PathAwareVariableStatusInfo visitQualifiedAccessNode(@NotNull QualifiedAccessNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareVariableStatusInfo>> data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareVariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirQualifiedAccess[] firQualifiedAccessArray = new FirQualifiedAccess[]{node.getFir()};
            return this.visitQualifiedAccesses(dataForNode, firQualifiedAccessArray);
        }

        /*
         * WARNING - void declaration
         */
        private final PathAwareVariableStatusInfo visitAnnotation(PathAwareVariableStatusInfo dataForNode, FirAnnotation annotation2) {
            PathAwareVariableStatusInfo pathAwareVariableStatusInfo;
            if (annotation2 instanceof FirAnnotationCall) {
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((FirAnnotationCall)annotation2).getArgumentList().getArguments();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirQualifiedAccess it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    FirExpression it = (FirExpression)element$iv$iv;
                    boolean bl2 = false;
                    if ((it instanceof FirQualifiedAccess ? (FirQualifiedAccess)((Object)it) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                FirQualifiedAccess[] firQualifiedAccessArray = thisCollection$iv.toArray(new FirQualifiedAccess[0]);
                if (firQualifiedAccessArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                FirQualifiedAccess[] qualifiedAccesses = firQualifiedAccessArray;
                pathAwareVariableStatusInfo = this.visitQualifiedAccesses(dataForNode, Arrays.copyOf(qualifiedAccesses, qualifiedAccesses.length));
            } else {
                pathAwareVariableStatusInfo = dataForNode;
            }
            return pathAwareVariableStatusInfo;
        }

        /*
         * WARNING - void declaration
         */
        private final PathAwareVariableStatusInfo visitQualifiedAccesses(PathAwareVariableStatusInfo dataForNode, FirQualifiedAccess ... qualifiedAccesses) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            Object $this$mapNotNull$iv = qualifiedAccesses;
            boolean $i$f$mapNotNull = false;
            FirQualifiedAccess[] firQualifiedAccessArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                FirPropertySymbol it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ValueWritesWithoutReading.visitQualifiedAccesses$retrieveSymbol(this, (FirQualifiedAccess)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            FirPropertySymbol[] firPropertySymbolArray = thisCollection$iv.toArray(new FirPropertySymbol[0]);
            if (firPropertySymbolArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            FirPropertySymbol[] symbols2 = firPropertySymbolArray;
            VariableStatus status2 = VariableStatus.READ;
            status2.setRead(true);
            return this.update(dataForNode, Arrays.copyOf(symbols2, symbols2.length), (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(status2){
                final /* synthetic */ VariableStatus $status;
                {
                    this.$status = $status;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus it) {
                    return this.$status;
                }
            }));
        }

        @Override
        @NotNull
        public PathAwareVariableStatusInfo visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareVariableStatusInfo>> data) {
            FirPropertySymbol symbol2;
            FirPropertySymbol firPropertySymbol;
            FirPropertySymbol[] firPropertySymbolArray;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareVariableStatusInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirResolvedNamedReference firResolvedNamedReference = UtilsKt.getResolved(node.getFir().getCalleeReference());
            if (firResolvedNamedReference == null) {
                return dataForNode;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol<?> firBasedSymbol = reference.getResolvedSymbol();
            FirFunctionSymbol firFunctionSymbol = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
            if (firFunctionSymbol == null) {
                return dataForNode;
            }
            FirFunctionSymbol functionSymbol = firFunctionSymbol;
            if (Intrinsics.areEqual((Object)functionSymbol.getCallableId().getCallableName().getIdentifier(), (Object)"invoke")) {
                Object v2;
                block6: {
                    firPropertySymbolArray = (FirPropertySymbol[])this.localProperties;
                    for (Object t : firPropertySymbolArray) {
                        FirPropertySymbol it = (FirPropertySymbol)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)reference.getName()) && InferenceUtilsKt.isFunctionalType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), this.session))) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                firPropertySymbol = v2;
            } else {
                firPropertySymbol = null;
            }
            if ((symbol2 = firPropertySymbol) == null) {
                return dataForNode;
            }
            VariableStatus status2 = VariableStatus.READ;
            status2.setRead(true);
            firPropertySymbolArray = new FirPropertySymbol[]{symbol2};
            return this.update(dataForNode, firPropertySymbolArray, (Function1<? super VariableStatus, ? extends VariableStatus>)((Function1)new Function1<VariableStatus, VariableStatus>(status2){
                final /* synthetic */ VariableStatus $status;
                {
                    this.$status = $status;
                    super(1);
                }

                @Nullable
                public final VariableStatus invoke(@Nullable VariableStatus it) {
                    return this.$status;
                }
            }));
        }

        private final PathAwareVariableStatusInfo update(PathAwareVariableStatusInfo pathAwareInfo, FirPropertySymbol[] symbols2, Function1<? super VariableStatus, ? extends VariableStatus> updater) {
            PersistentMap<EdgeLabel, VariableStatusInfo> resultMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            boolean changed = false;
            for (Map.Entry entry : ((Map)pathAwareInfo).entrySet()) {
                EdgeLabel label = (EdgeLabel)entry.getKey();
                VariableStatusInfo dataPerLabel = (VariableStatusInfo)entry.getValue();
                for (FirPropertySymbol symbol2 : symbols2) {
                    VariableStatus v = (VariableStatus)((Object)updater.invoke(dataPerLabel.get((Object)symbol2)));
                    if (v != null) {
                        resultMap = resultMap.put(label, (VariableStatusInfo)dataPerLabel.put(symbol2, (Object)v));
                        changed = true;
                        continue;
                    }
                    resultMap = resultMap.put(label, dataPerLabel);
                }
            }
            return changed ? new PathAwareVariableStatusInfo(resultMap) : pathAwareInfo;
        }

        private static final FirPropertySymbol visitQualifiedAccesses$retrieveSymbol(ValueWritesWithoutReading this$0, FirQualifiedAccess qualifiedAccess) {
            FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(qualifiedAccess.getCalleeReference());
            FirPropertySymbol firPropertySymbol = firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
            if (firPropertySymbol == null) {
                return null;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            return !this$0.localProperties.contains(symbol2) ? null : symbol2;
        }

        public static final /* synthetic */ Set access$getLocalProperties$p(ValueWritesWithoutReading $this) {
            return $this.localProperties;
        }
    }
}

