/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Attachment {
    private static final Logger LOG = Logger.getInstance(Attachment.class);
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final String myDisplayText;
    private final byte @Nullable [] myBytes;
    @Nullable
    private final File myTemporaryFile;
    private boolean myIncluded;

    public Attachment(@NotNull @NonNls String name, @NotNull Throwable throwable) {
        if (name == null) {
            Attachment.$$$reportNull$$$0(0);
        }
        if (throwable == null) {
            Attachment.$$$reportNull$$$0(1);
        }
        this(name + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    public Attachment(@NotNull @NonNls String path2, @NotNull @NonNls String content) {
        if (path2 == null) {
            Attachment.$$$reportNull$$$0(2);
        }
        if (content == null) {
            Attachment.$$$reportNull$$$0(3);
        }
        this(path2, content, content.getBytes(StandardCharsets.UTF_8), null);
    }

    private Attachment(String path2, String displayText, byte @Nullable [] bytes, @Nullable File temporaryFile) {
        assert (bytes != null || temporaryFile != null);
        this.myPath = path2;
        this.myDisplayText = displayText;
        this.myBytes = bytes;
        this.myTemporaryFile = temporaryFile;
    }

    @NotNull
    public String getDisplayText() {
        String string2 = this.myDisplayText;
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public String getPath() {
        String string2 = this.myPath;
        if (string2 == null) {
            Attachment.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/Attachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/Attachment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedBytes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

