/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.nexus.maven.staging.deploy.DeployableArtifact;
import org.sonatype.nexus.maven.staging.deploy.strategy.AbstractDeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployPerModuleRequest;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;

@Component(role=DeployStrategy.class, hint="direct")
public class DirectDeployStrategy
extends AbstractDeployStrategy {
    @Requirement
    private ArtifactDeployer artifactDeployer;

    @Override
    public void deployPerModule(DeployPerModuleRequest request) throws ArtifactInstallationException, ArtifactDeploymentException, MojoExecutionException {
        this.getLogger().info("Performing direct deploys (maven-deploy-plugin like)...");
        ArtifactRepository deploymentRepository = this.getDeploymentRepository(request.getMavenSession());
        ArtifactRepository localRepository = request.getMavenSession().getLocalRepository();
        for (DeployableArtifact deployableArtifact : request.getDeployableArtifacts()) {
            this.artifactDeployer.deploy(deployableArtifact.getFile(), deployableArtifact.getArtifact(), deploymentRepository, localRepository);
        }
    }

    @Override
    public void finalizeDeploy(FinalizeDeployRequest request) throws ArtifactDeploymentException, MojoExecutionException {
    }
}

