/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.rewriting;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.util.StreamReader2Delegate;

public class MutableXMLStreamReader
extends StreamReader2Delegate
implements AutoCloseable {
    private static final XMLInputFactory FACTORY = XMLInputFactory2.newInstance();
    private StringBuilder source;
    private final Path fileName;
    private boolean modified;
    private final Map<Object, MarkInfo> marks = new HashMap<Object, MarkInfo>();
    private final int[] delta = new int[2];
    private Charset sourceEncoding;

    public MutableXMLStreamReader(Path path) throws IOException, XMLStreamException, TransformerException {
        this(Files.newInputStream(path, new OpenOption[0]), path);
    }

    public MutableXMLStreamReader(InputStream inputStream, Path fileName) throws IOException, XMLStreamException, TransformerException {
        super(null);
        this.fileName = fileName;
        this.init(inputStream);
        this.rewind();
    }

    public Path getFileName() {
        return this.fileName;
    }

    public String getSource() {
        return this.source.toString();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getCurrentStartingCharOffset() {
        return this.delta[0] + (int)this.getLocationInfo().getStartingCharOffset();
    }

    public int getCurrentEndingCharOffset() {
        try {
            return this.delta[1] + (int)this.getLocationInfo().getEndingCharOffset();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    public void replace(String replacement) {
        int end;
        if (this.getEventType() == 7 || this.getEventType() == 8) {
            throw new IllegalStateException("Attempt at replacement outside of any element");
        }
        int start = this.getCurrentStartingCharOffset();
        if (this.source.substring(start, end = this.getCurrentEndingCharOffset()).equals(replacement)) {
            return;
        }
        this.source.replace(start, end, replacement);
        int delta = replacement.length() - (end - start);
        this.marks.values().stream().filter(mi -> mi.getEnd() == end).forEach(mi -> mi.setEnd(mi.getEnd() + delta));
        this.delta[1] = this.delta[1] + delta;
        this.modified = true;
    }

    private void validateMarks(Object ... marks) {
        for (Object mark : marks) {
            if (this.hasMark(mark)) continue;
            throw new IllegalStateException("Mark " + mark + " does not exist");
        }
    }

    private void validateMarkOffsets(Object mark1, Object mark2) {
        if (this.marks.get(mark1).getStart() > this.marks.get(mark2).getStart()) {
            throw new IllegalStateException("Start offset of " + mark1 + "(" + this.marks.get(mark1).getEnd() + ") > start offset of " + mark2 + "(" + this.marks.get(mark2).getStart() + ")");
        }
    }

    public String getBetween(Object mark1, Object mark2) {
        this.validateMarks(mark1, mark2);
        this.validateMarkOffsets(mark1, mark2);
        return Objects.equals(this.marks.get(mark1), this.marks.get(mark2)) ? "" : this.source.substring(this.marks.get(mark1).getEnd(), this.marks.get(mark2).getStart());
    }

    public void replaceBetween(Object mark1, Object mark2, String replacement) {
        this.validateMarks(mark1, mark2);
        this.validateMarkOffsets(mark1, mark2);
        int start = this.marks.get(mark1).getEnd();
        int end = this.marks.get(mark2).getStart();
        if (this.source.substring(start, end).equals(replacement)) {
            return;
        }
        this.source.replace(start, end, replacement);
        int delta = replacement.length() - (end - start);
        this.marks.values().stream().filter(mi -> mi.getStart() >= end).forEach(mi -> mi.setStart(mi.getStart() + delta));
        this.marks.values().stream().filter(mi -> mi.getEnd() >= end).forEach(mi -> mi.setEnd(mi.getEnd() + delta));
        this.delta[1] = this.delta[1] + delta;
        this.modified = true;
    }

    public void replaceMark(Object mark, String replacement) {
        this.validateMarks(mark);
        int start = this.marks.get(mark).getStart();
        int end = this.marks.get(mark).getEnd();
        if (this.source.substring(start, end).equals(replacement)) {
            return;
        }
        this.source.replace(start, end, replacement);
        int delta = replacement.length() - (end - start);
        this.marks.values().stream().filter(mi -> mi.getStart() >= end).forEach(mi -> mi.setStart(mi.getStart() + delta));
        this.marks.values().stream().filter(mi -> mi.getEnd() >= end).forEach(mi -> mi.setEnd(mi.getEnd() + delta));
        if (start < this.getCurrentStartingCharOffset()) {
            this.delta[0] = this.delta[0] + delta;
        }
        this.delta[1] = this.delta[1] + delta;
        this.modified = true;
    }

    public void rewind() throws XMLStreamException {
        if (this.getParent() != null) {
            this.getParent().close();
        }
        this.marks.clear();
        this.delta[0] = 0;
        this.delta[1] = 0;
        XMLStreamReader2 reader = (XMLStreamReader2)FACTORY.createXMLStreamReader(new ByteArrayInputStream(this.source.toString().getBytes(this.sourceEncoding)), this.sourceEncoding.toString());
        this.setParent((XMLStreamReader)reader);
    }

    public int next() throws XMLStreamException {
        this.delta[0] = this.delta[1];
        return super.next();
    }

    public boolean hasMark(Object markNr) {
        return this.marks.containsKey(markNr);
    }

    public void mark(Object markNr) {
        this.marks.put(markNr, new MarkInfo(this.getCurrentStartingCharOffset(), this.getCurrentEndingCharOffset()));
    }

    public void clearMark(Object markNr) {
        this.marks.remove(markNr);
    }

    private void init(InputStream inputStream) throws IOException, XMLStreamException, TransformerException {
        try (BufferedInputStream buf = new BufferedInputStream(inputStream);){
            buf.mark(16384);
            XMLStreamReader reader = FACTORY.createXMLStreamReader(buf);
            this.sourceEncoding = Optional.ofNullable(reader.getEncoding()).map(Charset::forName).orElse(Charset.defaultCharset());
            reader.close();
            buf.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.copy((InputStream)buf, (OutputStream)baos);
            this.source = new StringBuilder(baos.toString(this.sourceEncoding.toString()));
        }
    }

    static {
        FACTORY.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
    }

    private static class MarkInfo {
        private int start;
        private int end;

        MarkInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }

        int getStart() {
            return this.start;
        }

        void setStart(int value) {
            this.start = value;
        }

        int getEnd() {
            return this.end;
        }

        void setEnd(int value) {
            this.end = value;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MarkInfo)) {
                return false;
            }
            MarkInfo other = (MarkInfo)obj;
            return this.start == other.start && this.end == other.end;
        }

        public String toString() {
            return "MarkInfo[" + this.getStart() + ":" + this.getEnd() + "]";
        }
    }
}

