#!/bin/sh -e

VERSION=$2

DIR=apache-poi-$VERSION
TAR=../libapache-poi-java_$VERSION.orig.tar.gz
TAG=REL_`echo $VERSION | sed "s/\./_/"`

# Checkout the code from svn
svn export http://svn.apache.org/repos/asf/poi/tags/$TAG $DIR

# Fetch the OOXML schemas from the ECMA site.
# These files are available to all interested parties without
# restriction according to the ECMA bylaws:
# http://www.ecma-international.org/memento/Ecmabylaws.htm#art9.4
wget 'http://www.ecma-international.org/publications/files/ECMA-ST/Office%20Open%20XML%201st%20edition%20Part%204%20(PDF).zip'
unzip 'Office Open XML 1st edition Part 4 (PDF).zip' OfficeOpenXML-XMLSchema.zip
unzip OfficeOpenXML-XMLSchema.zip -d $DIR/ooxml-xsds
rm *.zip

GZIP=--best tar czf $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
