/*	$NetBSD: compat_kevent.c,v 1.4 2023/07/29 10:01:24 rin Exp $ */

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/cdefs.h>
#if defined(LIBC_SCCS) && !defined(lint)
__RCSID("$NetBSD: compat_kevent.c,v 1.4 2023/07/29 10:01:24 rin Exp $");
#endif /* LIBC_SCCS and not lint */

#include "namespace.h"
#define __LIBC12_SOURCE__
#include <sys/time.h>
#include <compat/sys/time.h>
#include <sys/event.h>
#include <compat/sys/event.h>
#include <stdlib.h>

__warn_references(kevent,
    "warning: reference to compatibility kevent(); include <sys/event.h> to generate correct reference")
__warn_references(__kevent50,
    "warning: reference to compatibility __kevent50(); use kevent()")

int
kevent(int kq, const struct kevent100 *changelist, size_t nchanges,
    struct kevent100 *eventlist, size_t nevents, const struct timespec50 *ts50)
{
	struct timespec ts, *tsp;

	if (ts50)
		timespec50_to_timespec(ts50, tsp = &ts);
	else
		tsp = NULL;
        return __kevent50(kq, changelist, nchanges, eventlist, nevents, tsp);
}

int
__kevent50(int kq, const struct kevent100 *changelist100, size_t nchanges,
    struct kevent100 *eventlist100, size_t nevents, const struct timespec *tsp)
{
	int retval;
	struct kevent *changelist;
	struct kevent *eventlist;

	changelist = malloc(sizeof(*changelist) * nchanges);
	if (changelist == NULL) {
		return -1;
	}

	eventlist = malloc(sizeof(*eventlist) * nevents);
        if (eventlist == NULL) {
		retval = -1;
		goto leave0;
	}

	for (size_t i = 0; i < nchanges; i++)
		kevent100_to_kevent(changelist100 + i, changelist + i);

	retval = __kevent100(kq, changelist, nchanges, eventlist, nevents, tsp);
	if (retval == -1)
		goto leave1;

	for (int i = 0; i < retval; i++)
		kevent_to_kevent100(eventlist + i, eventlist100 + i);

leave1:
	free(eventlist);
leave0:
	free(changelist);
	return retval;
}
