/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VM;
import org.ovirt.engine.sdk.decorators.VMKatelloErratum;
import org.ovirt.engine.sdk.entities.KatelloErrata;
import org.ovirt.engine.sdk.entities.KatelloErratum;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMKatelloErrata
extends CollectionDecorator<KatelloErratum, KatelloErrata, VMKatelloErratum> {
    private VM parent;

    public VMKatelloErrata(HttpProxyBroker proxy, VM parent) {
        super(proxy, "katelloerrata");
        this.parent = parent;
    }

    @Override
    public List<VMKatelloErratum> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, KatelloErrata.class, VMKatelloErratum.class);
    }

    @Override
    public VMKatelloErratum get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, KatelloErratum.class, VMKatelloErratum.class);
    }

    @Override
    public VMKatelloErratum getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, KatelloErratum.class, VMKatelloErratum.class);
    }

    public List<VMKatelloErratum> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, KatelloErrata.class, VMKatelloErratum.class, headers);
    }
}

