/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.HostNumaNode;
import org.ovirt.engine.sdk.decorators.HostNumaNodeStatistic;
import org.ovirt.engine.sdk.entities.Statistic;
import org.ovirt.engine.sdk.entities.Statistics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class HostNumaNodeStatistics
extends CollectionDecorator<Statistic, Statistics, HostNumaNodeStatistic> {
    private HostNumaNode parent;

    public HostNumaNodeStatistics(HttpProxyBroker proxy, HostNumaNode parent) {
        super(proxy, "statistics");
        this.parent = parent;
    }

    @Override
    public List<HostNumaNodeStatistic> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Statistics.class, HostNumaNodeStatistic.class);
    }

    @Override
    public HostNumaNodeStatistic get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Statistic.class, HostNumaNodeStatistic.class);
    }

    @Override
    public HostNumaNodeStatistic getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Statistic.class, HostNumaNodeStatistic.class);
    }
}

