/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetworkVnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterIscsiBondNetworkVnicProfiles
extends CollectionDecorator<VnicProfile, VnicProfiles, DataCenterIscsiBondNetworkVnicProfile> {
    private DataCenterIscsiBondNetwork parent;

    public DataCenterIscsiBondNetworkVnicProfiles(HttpProxyBroker proxy, DataCenterIscsiBondNetwork parent) {
        super(proxy, "vnicprofiles");
        this.parent = parent;
    }

    @Override
    public List<DataCenterIscsiBondNetworkVnicProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VnicProfiles.class, DataCenterIscsiBondNetworkVnicProfile.class);
    }

    @Override
    public DataCenterIscsiBondNetworkVnicProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VnicProfile.class, DataCenterIscsiBondNetworkVnicProfile.class);
    }

    @Override
    public DataCenterIscsiBondNetworkVnicProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, VnicProfile.class, DataCenterIscsiBondNetworkVnicProfile.class);
    }

    public DataCenterIscsiBondNetworkVnicProfile add(VnicProfile vnicprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, DataCenterIscsiBondNetworkVnicProfile.class, headers);
    }

    public List<DataCenterIscsiBondNetworkVnicProfile> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, VnicProfiles.class, DataCenterIscsiBondNetworkVnicProfile.class, headers);
    }
}

