/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javascript.grunt.ui.customizer;

import java.awt.EventQueue;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

class GruntCustomizerPanel extends JPanel {

    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport(this);

    private volatile String tasks = null;


    public GruntCustomizerPanel(Project project, String tasks) {
        assert EventQueue.isDispatchThread();
        assert project != null;
        this.project = project;
        this.tasks = tasks;
        initComponents();
        init();
    }

    private void init() {
        // listeners
        tasksTextField.getDocument().addDocumentListener(new TasksDocumentListener());
        // values
        tasksTextField.setText(tasks);
    }

    void addChangeListener(ChangeListener listener) {
        changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        changeSupport.removeChangeListener(listener);
    }

    String getTaks() {
        return tasks;
    }

    String getErrorMessage() {
        return null;
    }

    @NbBundle.Messages({
        "# {0} - directory",
        "GruntCustomizerPanel.warning.dir.notExist=Directory \"{0}\" does not exist",
    })
    String getWarningMessage() {
        FileObject projectDirectory = project.getProjectDirectory();
        for (String dir : StringUtilities.explode(tasks, ",")) { // NOI18N
            if (projectDirectory.getFileObject(dir.trim().replace('\\', '/')) == null) {
                return Bundle.GruntCustomizerPanel_warning_dir_notExist(dir.trim());
            }
        }
        return null;
    }

    void fireChange() {
        changeSupport.fireChange();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tasksLabel = new JLabel();
        tasksTextField = new JTextField();
        tasksInfoLabel = new JLabel();

        tasksLabel.setLabelFor(tasksTextField);
        Mnemonics.setLocalizedText(tasksLabel, NbBundle.getMessage(GruntCustomizerPanel.class, "GruntCustomizerPanel.tasksLabel.text")); // NOI18N

        Mnemonics.setLocalizedText(tasksInfoLabel, NbBundle.getMessage(GruntCustomizerPanel.class, "GruntCustomizerPanel.tasksInfoLabel.text")); // NOI18N

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(tasksLabel)
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addComponent(tasksInfoLabel)
                    .addComponent(tasksTextField)))
        );
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(tasksLabel)
                    .addComponent(tasksTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tasksInfoLabel)
                .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JLabel tasksInfoLabel;
    private JLabel tasksLabel;
    private JTextField tasksTextField;
    // End of variables declaration//GEN-END:variables

    //~ Inner classes

    private final class TasksDocumentListener implements DocumentListener {

        @Override
        public void insertUpdate(DocumentEvent e) {
            processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            processChange();
        }

        private void processChange() {
            tasks = tasksTextField.getText();
            fireChange();
        }

    }

}
