KeyDispatcher.KEY_UP    = 0x01;
KeyDispatcher.KEY_DOWN  = 0x02;
KeyDispatcher.KEY_LEFT  = 0x04;
KeyDispatcher.KEY_RIGHT = 0x08;
KeyDispatcher.KEY_TRG1  = 0x10;
KeyDispatcher.KEY_TRG2  = 0x20;

function KeyDispatcher(element)
{
	this.keyState = 0;
	this.itime = 0;

	Event.observe(element, "keydown", this.onKeyDown.bind(this), true);
	Event.observe(element, "keyup", this.onKeyUp.bind(this), true);
	return this;
}

function KeyDispatcher_checkTimeout(t)
{
	if (window.opera) return;
	
	this.itime += t;
	if (this.itime > 1000)
		this.keyState = 0;
}
KeyDispatcher.prototype.checkTimeout = KeyDispatcher_checkTimeout;

function KeyDispatcher_onKeyDown(e)
{
	this.itime = 0;
	this.keyState |= KeyDispatcher_getKeyFlg(e);

	Event.stop(e);
}
KeyDispatcher.prototype.onKeyDown = KeyDispatcher_onKeyDown;

function KeyDispatcher_onKeyUp(e)
{
	this.itime = 0;
	this.keyState &= ~KeyDispatcher_getKeyFlg(e);
	
	Event.stop(e);
}
KeyDispatcher.prototype.onKeyUp = KeyDispatcher_onKeyUp;


function KeyDispatcher_getKeyFlg(e)
{
	var ret = 0;
	
	switch(e.keyCode)
	{
	case 104:
	case Event.KEY_UP:    
		ret = KeyDispatcher.KEY_UP;    break;
	case 98:
	case Event.KEY_DOWN:  
		ret = KeyDispatcher.KEY_DOWN;  break;
	case 100:
	case Event.KEY_LEFT:  
		ret = KeyDispatcher.KEY_LEFT;  break;
	case 102:
	case Event.KEY_RIGHT: 
		ret = KeyDispatcher.KEY_RIGHT; break;
	
	case 88: ret = KeyDispatcher.KEY_TRG2; break;
	case 90: ret = KeyDispatcher.KEY_TRG1; break;
	}
	
	return ret;
}
