#ifndef VIDEOSETTINGSCODE_H
#define VIDEOSETTINGSCODE_H

#include "VideoSettings.h"
#include "VideoDevice.h"

class CVideoSettingsDlg: public CVideoSettings
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   CVideoDeviceTuner *pTuner;
   
   bool IsPhilips;
   int m_WBMode;
   int m_WBRed, m_WBBlue;
   QTimer AutoTimer;

   QSize sizes[7];
   QSize size, org_size, max_size;
   int fps, org_fps;

   int FreqSystem;
   QArray<float> Frequencies;
   float CentralFrequency;	/// Last selected frequency
       
   void GetCamSizeFrame(bool First = FALSE);
   void EnableTuning(bool doit);

private slots:
   // callback from CVideoDevice
   void SizeChanged(const QSize &);
   void FramerateChanged(int);
   void UpdateAuto();

protected:
   void hideEvent(QHideEvent *);
   void showEvent(QShowEvent *);

protected slots:
   // User actions
   // 1st group: Size & Frame
   virtual void ClickedSize(int);
   virtual void ClickedRate(int);
   // 2nd group: Video controls
   virtual void MovedBrightness(int);
   virtual void MovedContrast(int);
   virtual void MovedGamma(int);
   virtual void MovedColour(int);

   // 3rd group: Tuning
   virtual void ClickedInputSelector(int);
   virtual void ClickedTunerSelector(int);
   virtual void ClickedFrequencySystem(int);
   virtual void ClickedChannel();
   virtual void MovedFineTuning(int);

   // 4th group: Philips Extensions
   virtual void ToggledAGC(bool);
   virtual void MovedAGC(int);
   virtual void ToggledShutter(bool);
   virtual void MovedShutter(int);
   virtual void ToggledContour(bool);
   virtual void MovedContour(int);
   virtual void ToggledBacklight(bool);
   virtual void ToggledFlicker(bool);
   virtual void ChangedNoise(int);
   virtual void ChangedCompression(int);
   virtual void ChangedWB(int);
   virtual void MovedRed(int);
   virtual void MovedBlue(int);
   virtual void MovedWBSpeed(int);
   virtual void MovedWBDelay(int);
   virtual void ClickedSaveUser();
   virtual void ClickedRestoreUser();
   virtual void ClickedRestoreFactory();

public:
   CVideoSettingsDlg(CVideoDevice *video);   

signals:
   void DialogClosed();
   void Changed(QSize, int);
};

#endif
