#ifndef CAMSTREAMAPP_HPP
#define CAMSTREAMAPP_HPP

#ifdef HAVE_CONFIG_H
#incude <config.h>
#endif

#include <qapplication.h>
#include <qcolor.h>
#include <qdict.h>
#include <qdom.h>
#include <qfile.h>
#include <qfont.h>
#include <qstring.h>

#include "VideoOptions.h"
#include "VideoCollector.h"

/** \file CamStreamApp.h
    Include file for main object; contains some global stuff, including
    the configuration file (which is an XML document)
 */


/** \enum FileTypeEnum 
  Enumeration for image file types we support. 
  
  Current supported formats: JPG, PNG, PPM, BMP (but only if the proper 
  libaries are linked in)
 */
enum FileTypeEnum 
{
   file_jpeg,
   file_png,
   file_ppm,
   file_bmp,

   file_MAX
};


class CCamStreamApp: public QApplication
{
private:
   QFile ConfigFile;
   QString UploadDir;

   int snap_bitmask;	/* possible file formats */

   QList<SVideoOptions> VOpts;

   QDict<QString> VisiblePanels;
   
   void InitFileTypes();

   void ReadConfigFile();
   void SaveConfigFile();

public:
   CVideoCollector *VideoDevices;
   struct {
     QDomDocument Root;
     QDomElement Defaults;
     QDomElement VideoDevices;
   } Configuration;

   CCamStreamApp(int argc, char *argv[]);
   ~CCamStreamApp();
   
   QString GetUploadTmpDir() const;

   /* File name and type for saved images */
   int GetNumberOfFileTypes() const;
   int GetFileTypeMask() const;
   QString GetFileTypeExtension(int n) const;
   QString GetFileTypeFormatStr(int n) const;
   int FormatStrToEnum(const QString &) const;
   QString FormatStrToExtension(const QString &) const;

   SVideoOptions *FindVideoOptions(const QString &name, const QString &node, bool create = FALSE);
};

/// Global pointer to the one and only CCamStreamApp instance
extern CCamStreamApp *CamApp;

#endif

