<?php

//   XUL Webmail, a web based mailclient
//
//  Copyright (C) 2004-05 Xiffy.nl (?)
//  Copyright (C) 2004-05 Achim J. Latz (xwm a@t latz.org)
//
//  PHP Word Wrap routine
//  Version 1.0.1, Jan 5th 2004
//  Copyright 2004 Kohan Ikin
//  syneryder@namesuppressed.com
//  http://www.namesuppressed.com/syneryder/
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

class message {

	var $wordwrap;

    function message ($url, $username, $password, $id) {

        $this->mimetypes = array("TEXT", "MULTIPART","message", "APPLICATION", "AUDIO","IMAGE", "VIDEO", "OTHER");

        $this->mbox = imap_open($url, $username, $password)

          or die("can't connect: ".imap_last_error());

	$newid = imap_msgno($this->mbox, $id);

	$this->wordwrap = 80;

	$this->id = $id;

	$this->textBody ="This is a TXT place holder";

	$this->htmlBody ="<b>This is a HTML <i> place holder </i><b?";

	$this->mailformat="text";

        $this->msgno = $newid;

	$this->attachmentCount = 0;
	
        $this->headers = imap_header($this->mbox, $newid);

        $this->structure = imap_fetchstructure($this->mbox, $newid);

        $this->textbody = array();

        $this->getBodyparts($this->structure);

        $this->getAttachments();

	

        imap_close($this->mbox);

    }

    // TODO: Investigate why $from results in empty space
    function getReplyBody() {
	    // this variable should be read from the settings.php file
	    // prevented for now by circular dependencies
	    
	    // attribution line
	    $body .= "On " . $this->getDate() . ", " . $this->getFrom() . " wrote: \n\n";
	    $orig = "> " . $this->getRawTextBody();
	    $orig = wordwrap($orig);
	    $new = str_replace("\n","\n> ",$orig);
	    $body .= $new . "\n\n";
	return $body;
    }

    function getForwardBody() {
	    // display message body with forward symbol >
	    $body .= (("\n\n"));
	    $body .= (("---------- Forwarded message ----------\n"));
	    $body .= (("From: ". $this->getFrom(). "\n"));
	    $body .= (("To: " . $this->getTo() . "\n"));
	    if($this->hasCC()) {
		    $body .= (("Cc: " . $this->getCC() . "\n"));
	    }
	    $body .= (("Date: " . $this->getDate() . "\n"));
	    $body .= (("Subject: " . $this->getSubject()));

	    // make some space between headers and body, and include a '>' for the first line of the message! 
	    $body .= "\n\n";
	    $body .= $this->getRawTextBody();
	    return $body;

	    // if attachments exist
	    // display as list of checkboxes
	    /*
	    if (is_array($attachments)) {
		    $body .=  "<input type=checkbox checked name=amsg[] value=" .
		    $attachments[$x]["pid"] . ">" . $attachments[$x]["name"] . " (" .
		    ceil($attachments[$x]["size"]/1024) . " KB)<br>";
		    */
    }
    
    // check for Reply-To: header and use if available
    function getReplyTo() {
	if($this->headers->reply_toaddress) {
		return $this->headers->reply_toaddress;
	} else {
		return $this->getFrom();
	}
    }
    
    function getDate() {
	    return $this->headers->Date; 
    }

    function hasCC() {
	    if (strcasecmp($this->getCC(), "")) {
		    return false;
	    } else {
		    return true;
	    }
    }
    
    function getCC() {
	    return $this->headers->ccaddress;
    }

    // get Re: Subject line
    function getReSubject() {
	// check for Re: in subject header
	if(strtolower(substr(($this->getSubject()), 0, 3)) == "re:") {
		return $this->getSubject();
	} else {
		return "Re: " . $this->getSubject();
	}
    }
    
    function getForwardSubject() {
	// check for Re: in subject header
	if(strtolower(substr(($this->getSubject()), 0, 4)) == "fwd:") {
		return $this->getSubject();
	} else {
		return "Fwd: " . $this->getSubject();
	}
    }

    function getSubject() {
	    return mime_decode($this->headers->Subject);
    }
    
    function hasAttachments() {
	    if ($this->attachmentCount > 0) {
		    return true;
	    } else {
		    return false;
	    }
    }
    
    // add mime_decode in all functions!
    function getFrom() {
	    return mime_decode($this->headers->fromaddress);
    }

    function getTo() {
	    return $this->headers->toaddress;
    }

    function getBodyparts($struct,$pid = 1) {

        if ($struct) {

            $this->$this->textbody[]       .= "<b>".$pid."</b>\n";

		// GET TEXT BODY
		$dataTxt = $this->get_part($this->mbox, $this->msgno, "TEXT/PLAIN", $struct);
   
		// GET HTML BODY
		$dataHtml = $this->get_part($this->mbox, $this->msgno, "TEXT/HTML", $struct);

		$this->textBody = $dataTxt;
		$this->htmlBody = $dataHtml;

		if ($dataHtml != "") {
			$this->mailformat = "html";
		} else {
			$this->mailformat = "text";
		}
       }
    }

    function getTextBody() {
	    $text = wordwrap($this->textBody);
	    return $text;
    }
	    
    function getRawTextBody() {
	    return $this->textBody;
    }

    
    function getHTMLBody() {
	    if ($this->mailformat == "html") {
		$body = $this->htmlBody;
		$body = $this->transformHTML($body);
	    } else {
		$body = $this->getTextBody();
		$body = "<pre>" . $body . "</pre>";
		$body = preg_replace("/([^\w\/])(www\.[a-z0-9\-]+\.[a-z0-9\-]+)/i","$1http://$2",    $body);
		$body = preg_replace( "`((http)+(s)?:(//)|(www\.))((\w|\.|\-|_)+)(/)?(\S+)?`i", "<a target=\"_blank\" href=\"http\\3://\\5\\6\\8\\9\" title=\"\\0\">\\0</a>", $body);
		// old URL version: preg_replace("/([\w]+:\/\/[\w-?&;#~=\.\/\@\,\$]+[\w\/])/i","<A    TARGET=\"_blank\" HREF=\"$1\">$1</A>", $body);
		$body = preg_replace("/([\w-?&;#~=\.\/]+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?))/i","<A    HREF=\"mailto:$1\">$1</A>",$body);
		$body = $this->transformHTML($body);
	    }
	    return $body;
    }

    function getAttachments(){

        $this->attachmentCount = 0;

        $contentParts = count($this->structure->parts);

        if($contentParts > 1){

            for($i=1; $i<=$contentParts; $i++){

                if($this->structure->parts[$i]->type > 0){

                    $this->attachments[$this->attachmentCount] = $this->structure->parts[$i]->dparameters[0]->value;

                    $this->attachmentCount++;

                }

            }

        }

    }
    
   function get_part($stream, $msg_number, $mime_type, $structure = false,$part_number = false) {
   
   	if(!$structure) {
   		$structure = imap_fetchstructure($stream, $msg_number);
   	}
   	if($structure) {
   		if($mime_type == $this->get_mime_type($structure)) {
   			if(!$part_number) {
   				$part_number = "1";
   			}
   			$text = imap_fetchbody($stream, $msg_number, $part_number);
   			if($structure->encoding == 3) {
   				return imap_base64($text);
   			} else if($structure->encoding == 4) {
   				return imap_qprint($text);
   			} else {
   			return $text;
   		}
   	}
   
		if($structure->type == 1) /* multipart */ {
   		while(list($index, $sub_structure) = each($structure->parts)) {
   			if($part_number) {
   				$prefix = $part_number . '.';
   			}
   			$data = $this->get_part($stream, $msg_number, $mime_type, $sub_structure,$prefix .    ($index + 1));
   			if($data) {
   				return $data;
   			}
   		} // END OF WHILE
   		} // END OF MULTIPART
   	} // END OF STRUTURE
   	return false;
   } // END OF FUNCTION
   
   function get_mime_type($structure) {
	   $primary_mime_type = array("TEXT", "MULTIPART","MESSAGE", "APPLICATION", "AUDIO","IMAGE", "VIDEO", "OTHER");
   
	   if($structure->subtype) {
		   return $primary_mime_type[(int) $structure->type] . '/' .$structure->subtype;
	   }
   	
	   return "TEXT/PLAIN";
   }

 function transformHTML($str) {
   if ((strpos($str,"<HTML") < 0) || (strpos($str,"<html")    < 0)) {
  		$makeHeader = "<html><head><meta http-equiv=\"Content-Type\"    content=\"text/html; charset=iso-8859-1\"></head>\n";
   	if ((strpos($str,"<BODY") < 0) || (strpos($str,"<body")    < 0)) {
   		$makeBody = "\n<body>\n";
   		$str = $makeHeader . $makeBody . $str ."\n</body></html>";
   	} else {
   		$str = $makeHeader . $str ."\n</html>";
   	}
   } else {
   	$str = "<meta http-equiv=\"Content-Type\" content=\"text/html;    charset=iso-8859-1\">\n". $str;
   }
   	return $str;
 }

// PHP Word Wrap routine
// Version 1.0.1, Jan 5th 2004
// Copyright 2004 Kohan Ikin
// syneryder@namesuppressed.com
// http://www.namesuppressed.com/syneryder/

// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the author be held liable for any damages
// arising from the use of this software.

// Permission is granted to use this code for any purpose, but its origin
// must not be misrepresented (ie you must not claim you wrote the code or
// the accompanying tutorial).  If you use this code I would appreciate a
// short email explaining where and how the code is being used, but you
// don't have to if you're too shy :)

// Version History
// 1.00  2000.12.22  Initial release
// 1.01  2004.01.05  Fixed a bug causing tokens that evaluate
//                   to zero to be truncated.  Thanks to Joe
//                   Pfeiffer at New Mexico State University
//                   Computer Science Department and Dave Holle
//                   for alerting me to the problem.



##############################################################
#  wordwrapLine
#
#  Reformats a string to fit within a display with a certain
#  number of columns.  Words are moved between the lines as
#  necessary.  Particularly useful for formatting text to
#  be sent via email (prevents nasty wrap-around problems).
#
#  Params:    $s, the string to be formatted
#             $l, the maximum length of a line
#  Returns:   a string formatted to $width columns
#  Notes:     assumes no newline characters in input
##############################################################

function wordwrapLine($s, $l) {

  $tok = strtok($s, " ");
  while (strlen($tok) != 0) {
    if (strlen($line) + strlen($tok) < ($l + 2) ) {
      $line .= " $tok";
    }
    else {
      $formatted .= "$line\n";
      $line = $tok;
    }
    $tok = strtok(" ");
  }
  $formatted .= $line;
  $formatted = trim($formatted);
  return $formatted;
}

##############################################################
#  wordwrap
#
#  Reformats a string to fit within a display with a certain
#  number of columns.  Words are moved between the lines as
#  necessary.  Particularly useful for formatting text to
#  be sent via email (prevents nasty wrap-around problems).
#
#  Params:    $str, the string to be formatted
#             $linelength, the maximum length of a line
#  Returns:   a string formatted to $width columns
##############################################################

function wordwrap($str) {

  $linelength = $this->wordwrap;
  
  $str = ereg_replace("([^\r\n])\r\n([^\r\n])", "\\1 \\2", $str);
  $str = ereg_replace("[\r\n]*\r\n[\r\n]*", "\r\n\r\n", $str);
  $str = ereg_replace("[ ]* [ ]*", ' ', $str);
  $str = StripSlashes($str);
  
  $paragraphs = explode("\n", $str);
  $cnt = 0;
  while($cnt < sizeof($paragraphs)) {
    $para = trim(current($paragraphs)); 
    $newparas .= wordwrapLine($para, $linelength) . "\n";
    next($paragraphs);
    $cnt++;
  }
  $newparas = trim($newparas);
  return $newparas;
}


}


?>
