<?
//   XUL Webmail, a web based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw a@t dds.nl), others
//   Copyright (C) 2004-05 Achim J. Latz (xwm a@t latz.org)
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

function unsetSessionVariable ($sessionVariableName) {
   unset($GLOBALS['_SESSION'][$sessionVariableName]);
   session_unregister($sessionVariableName);
}

function destroy_session() {
	// destroy session variables 
	session_start();
	unsetSessionVariable("server");
	unsetSessionVariable("user");
	unsetSessionVariable("pass");
	unsetSessionVariable("email");
	unsetSessionVariable("realname");
	unsetSessionVariable("session");
	
	// Unset all of the session variables.
	$_SESSION = array();
	
	// If it's desired to kill the session, also delete the session cookie.
	// Note: This will destroy the session, and not just the session data!
	if (isset($_COOKIE[session_name()])) {
   		setcookie(session_name(), '', time()-42000, '/');
	}
	
	// Finally, destroy the session.
	session_destroy();	

	return true;
}

	// logout.php - destroy session
	session_start();
	// Unset the session variables.
	session_unset();
	// destroy the session.
	if (destroy_session()) {
		// echo "<html><body onload=\"javascript:window.close();window.location.href='error.php?ec=3';\"></body></html>";
	}
?>