/* #define DEBUG */

#define H_LOOP 1
#define H_MANY 2
#define H_STREAM 4
#define H_NOISY 8
#define H_REPEATCOUNT 16
#define H_PRELOAD 32
#define H_DAEMON 64
#define H_EXITS 128
#define H_IGNORE_ERRORS 256
#define H_NOKILL 0x100
#define H_SWALLOW 0x200
#define H_MAXASPECT 0x400
#define H_FILL 0x800

#define BUFSIZE 1024*256

#define my_timercmp(tvp, cmp, uvp) \
  ( (tvp)->tv_sec == (uvp)->tv_sec ? \
    (tvp)->tv_usec cmp (uvp)->tv_usec : \
    (tvp)->tv_sec cmp (uvp)->tv_sec )

#define INC_TIME(tvp, sec, usec) do {			\
  (tvp)->tv_usec += (usec);				\
  (tvp)->tv_sec += (sec);				\
  if( (tvp)->tv_usec > 1000000 ) {			\
    (tvp)->tv_sec++ ; (tvp)->tv_usec -= 1000000 ;	\
  }							\
}while(0)

#define MAXIMUM(X,Y) ((X)>(Y)?(X):(Y))
#define MINIMUM(X,Y) ((X)<(Y)?(X):(Y))

#ifdef DEBUG
static FILE *debug_output=0;
static FILE *getout()
{
  if(debug_output) return debug_output;
  debug_output=fopen("/tmp/ndebug","a+");
  fprintf(debug_output,"------------\n");
  return   debug_output;
}
static void D(char *fmt, ...)
{
  FILE *f;
  char buffer[9999];
  va_list ap;

  va_start(ap,fmt);
  vsnprintf(buffer,sizeof(buffer),fmt,ap);
  va_end(ap);

  if((f=getout()))
  {
    fprintf(f,"PID%4d: %s",getpid(),buffer);
    fflush(f);
  }
}
#else
static void D(char *fmt, ...) { }
#endif

#ifndef MIN
#define MIN(X,Y) ((X)<(Y)?(X):(Y))
#endif

#ifndef MAXINT
#define MAXINT 0x7fffffff
#endif

