/*** -*- Mode: Javascript; tab-width: 2;

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Mozdev Group, Inc. code.
The Initial Developer of the Original Code is Pete Collins.

Portions created by Mozdev Group, Inc. are
Copyright (C) 2003 Mozdev Group, Inc.  All
Rights Reserved.

Contributor(s): Pete Collins <pete@mozdev.org)> (original author)

***/

/****************** Globals **********************/

if(typeof(JS_LIB_LOADED)=='boolean') {

const JS_APPROUTINES_FILE     = "appRoutines.js";
const JS_APPROUTINES_LOADED   = true;


/****************** Common Application Routines *********************/

/**************************** QUIT **********************************/
function jslibQuit() {

	try {
	  var windowManager = C.classes['@mozilla.org/appshell/window-mediator;1']
		                    .getService(C.interfaces.nsIWindowMediator);
    var enumerator = windowManager.getEnumerator(null);
		
		// we are only closing dom windows for now
		// var appShell = C.classes['@mozilla.org/appshell/appShellService;1'].getService();
		// appShell = appShell.QueryInterface(C.interfaces.nsIAppShellService);
		
		while (enumerator.hasMoreElements()) {
		  var domWindow = enumerator.getNext();
			if (("tryToClose" in domWindow) && !domWindow.tryToClose())
			  return false;
			domWindow.close();
		}
		// we are only closing dom windows for now
	  // appShell.quit(C.interfaces.nsIAppShellService.eAttemptQuit);
	} catch (e) {
      jslibPrint(e);
	}

  return true;
}

/**************************** QUIT **********************************/

jslibDebug('*** load: '+JS_APPROUTINES_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n" 

        + " \tThen: include('chrome://jslib/content/xul/appRoutines.js');\n\n");

}; // END FileSystem Class
