/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla;

import java.io.IOException;
import org.l10nZilla.Phrase;
import org.l10nZilla.SourcePhraseSingleton;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.l10nZilla;
import org.l10nZilla.l10nZillaConfigurationProperties;
import org.l10nZilla.reader.mozDBReader;
import org.l10nZilla.reader.mozJarReader;
import org.l10nZilla.reader.translationsReader;
import org.l10nZilla.translator;
import org.l10nZilla.writer.mozDBCreate;
import org.l10nZilla.writer.mozDBWriter;
import org.l10nZilla.writer.mozHTMLWriter;
import org.l10nZilla.writer.mozJarWriter;
import org.l10nZilla.writer.mozPOWriter;
import org.l10nZilla.writer.mozTxtWriter;
import org.l10nZilla.writer.translationsWriter;

public class commandCenter {
    public commandCenter(String command) {
    }

    public void doTranslateCommand(String sourceFileName, String destFileName, String preferredInstall, String logDatabaseDBInstall) throws IOException {
        translator myTranslator = null;
        Phrase translatedPhrase = null;
        mozHTMLWriter myNeedsTranslationsLog = null;
        mozHTMLWriter myHTMLTranslationsLog = null;
        String source = l10nZillaConfigurationProperties.instance().getProperty("sourceWorkingDirectory");
        if (!source.startsWith("jdbc")) {
            source = source.endsWith("/") ? String.valueOf(String.valueOf(source)).concat(String.valueOf(String.valueOf(sourceFileName))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(source))).append("/").append(sourceFileName)));
        }
        String srcLangCode = l10nZillaConfigurationProperties.instance().getProperty("sourceLanguageCode");
        String destination = l10nZillaConfigurationProperties.instance().getProperty("destinationWorkingDirectory");
        if (!destination.startsWith("jdbc")) {
            destination = destination.endsWith("/") ? String.valueOf(String.valueOf(destination)).concat(String.valueOf(String.valueOf(destFileName))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(destination))).append("/").append(destFileName)));
        }
        String trgtLangCode = l10nZillaConfigurationProperties.instance().getProperty("destinationLanguageCode");
        String dictionaryAddress = l10nZillaConfigurationProperties.instance().getProperty("dictionaryDBAddress");
        String htmlOutputLocation = l10nZillaConfigurationProperties.instance().getProperty("htmlTranslationResultsDirectory");
        String htmlNeedsTranslations = "";
        if (htmlOutputLocation.endsWith("/")) {
            htmlNeedsTranslations = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(htmlOutputLocation))).append(destFileName).append("-needsTranslation.html")));
            htmlOutputLocation = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(htmlOutputLocation))).append(destFileName).append(".html")));
        } else {
            htmlNeedsTranslations = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(htmlOutputLocation))).append("/").append(destFileName).append("-needsTranslation.html")));
            htmlOutputLocation = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(htmlOutputLocation))).append("/").append(destFileName).append(".html")));
        }
        System.out.println("L10NZilla translate beginning with following settings : ");
        System.out.println("--------------------------------------------------");
        System.out.println("");
        System.out.println("Source File : ".concat(String.valueOf(String.valueOf(source))));
        System.out.println("Source Language Code : ".concat(String.valueOf(String.valueOf(srcLangCode))));
        System.out.println("");
        System.out.println("Destination File : ".concat(String.valueOf(String.valueOf(destination))));
        System.out.println("Destination Language Code : ".concat(String.valueOf(String.valueOf(trgtLangCode))));
        System.out.println("");
        System.out.println("Dictionary Database URL : ".concat(String.valueOf(String.valueOf(dictionaryAddress))));
        System.out.println("Preferred Archive to Extract Translations : ".concat(String.valueOf(String.valueOf(preferredInstall))));
        System.out.println("");
        System.out.println("Translation HTML Log will be stored in : ".concat(String.valueOf(String.valueOf(htmlOutputLocation))));
        System.out.println("");
        translationsReader myReader = this.getReader("", source);
        myReader.setSourceLanguageCode(srcLangCode);
        translationsWriter myWriter = this.getWriter("", destination);
        myWriter.setTargetLanguageCode(trgtLangCode);
        myHTMLTranslationsLog = new mozHTMLWriter("", htmlOutputLocation);
        myHTMLTranslationsLog.setTargetLanguageCode(trgtLangCode);
        myNeedsTranslationsLog = new mozHTMLWriter("", htmlNeedsTranslations);
        myNeedsTranslationsLog.setTargetLanguageCode(trgtLangCode);
        if (myWriter.needTranslatorObject()) {
            myTranslator = new translator(dictionaryAddress, myReader.getSourceLanguageCode(), myWriter.getTargetLanguageCode());
            myTranslator.setPreferredInstall(preferredInstall);
            if (!logDatabaseDBInstall.equalsIgnoreCase("None")) {
                myTranslator.logTranslationsToDB(logDatabaseDBInstall, dictionaryAddress, myWriter.getTargetLanguageCode());
            }
        }
        TranslationFile currentFile = null;
        currentFile = myReader.getNextFile();
        translatedPhrase = new Phrase();
        boolean needsTranslatedFileFlag = false;
        while (currentFile != null) {
            myWriter.prepareExportFile();
            myHTMLTranslationsLog.prepareExportFile();
            myWriter.exportFile(currentFile);
            myHTMLTranslationsLog.exportFile(currentFile);
            if (myTranslator != null) {
                myTranslator.setTranslatedFile(currentFile);
            }
            if (currentFile != null) {
                myReader.getNextPhrase();
                while (!SourcePhraseSingleton.instance().phrase().isEmpty()) {
                    if (myTranslator != null) {
                        translatedPhrase.reset();
                        myTranslator.translatePhrase(SourcePhraseSingleton.instance().phrase(), translatedPhrase);
                        myWriter.exportPhrase(translatedPhrase);
                        myHTMLTranslationsLog.exportPhrase(translatedPhrase);
                        if (translatedPhrase.isTranslationNeeded()) {
                            if (!needsTranslatedFileFlag) {
                                myNeedsTranslationsLog.prepareExportFile();
                                myNeedsTranslationsLog.exportFile(currentFile);
                                needsTranslatedFileFlag = true;
                            }
                            myNeedsTranslationsLog.exportPhrase(translatedPhrase);
                        }
                    } else {
                        myWriter.exportPhrase(SourcePhraseSingleton.instance().phrase());
                        myHTMLTranslationsLog.exportPhrase(SourcePhraseSingleton.instance().phrase());
                    }
                    myReader.getNextPhrase();
                }
            }
            myWriter.concludeExportFile();
            myHTMLTranslationsLog.concludeExportFile();
            if (needsTranslatedFileFlag) {
                myNeedsTranslationsLog.concludeExportFile();
            }
            currentFile = myReader.getNextFile();
            needsTranslatedFileFlag = false;
        }
        myWriter.close();
        myHTMLTranslationsLog.close();
        if (myTranslator != null) {
            myTranslator.report();
        }
        System.out.println("Translation complete");
    }

    public void doArchiveCommand(String sourceFileName, String srcLangCode, String archiveName) throws IOException {
        String install = archiveName;
        Phrase translatedPhrase = null;
        String source = l10nZillaConfigurationProperties.instance().getProperty("sourceWorkingDirectory");
        source = source.endsWith("/") ? String.valueOf(String.valueOf(source)).concat(String.valueOf(String.valueOf(sourceFileName))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(source))).append("/").append(sourceFileName)));
        String dictionaryAddress = l10nZillaConfigurationProperties.instance().getProperty("dictionaryDBAddress");
        translationsReader myReader = this.getReader(install, source);
        myReader.setSourceLanguageCode(srcLangCode);
        translationsWriter myWriter = this.getWriter(install, dictionaryAddress);
        myWriter.setTargetLanguageCode(srcLangCode);
        TranslationFile currentFile = null;
        translatedPhrase = new Phrase();
        currentFile = myReader.getNextFile();
        while (currentFile != null) {
            myWriter.prepareExportFile();
            myWriter.exportFile(currentFile);
            if (currentFile != null) {
                translatedPhrase.reset();
                myReader.getNextPhrase();
                while (!SourcePhraseSingleton.instance().phrase().isEmpty()) {
                    SourcePhraseSingleton.instance().phrase().setTranslationQuality(l10nZilla.ARCHIVEDTRANSLATION_QUALITYID, "Archived Translation");
                    myWriter.exportPhrase(SourcePhraseSingleton.instance().phrase());
                    myReader.getNextPhrase();
                }
            }
            myWriter.concludeExportFile();
            currentFile = myReader.getNextFile();
        }
        myWriter.close();
        System.out.println("Archive complete");
    }

    private translationsReader getReader(String install, String source) throws IOException {
        mozJarReader reader = null;
        if (source.endsWith("jar")) {
            reader = new mozJarReader(install, source);
        }
        if (source.startsWith("jdbc")) {
            System.out.println("mozDBReader needs updating to newer database structure");
        }
        return reader;
    }

    private translationsWriter getWriter(String install, String destination) {
        translationsWriter writer = null;
        if (destination.startsWith("jdbc")) {
            writer = new mozDBWriter(install, destination);
        }
        if (destination.endsWith("txt")) {
            writer = new mozTxtWriter(install, destination);
        }
        if (destination.endsWith("jar")) {
            writer = new mozJarWriter(install, destination);
        }
        if (destination.endsWith("po")) {
            writer = new mozPOWriter(install, destination);
        }
        if (destination.endsWith("html")) {
            writer = new mozHTMLWriter(install, destination);
        }
        return writer;
    }

    void createTranslationsDatabase() {
        String destination = l10nZillaConfigurationProperties.instance().getProperty("dictionaryDBAddress");
        String adminTranslatorName = l10nZillaConfigurationProperties.instance().getProperty("translatorName");
        String adminTranslatorLanguage = l10nZillaConfigurationProperties.instance().getProperty("translatorLanguage");
        mozDBCreate creator = null;
        creator = new mozDBCreate(destination, adminTranslatorName, adminTranslatorLanguage);
        creator.createDB();
    }

    public void doShowArchivesCommand() {
        String dictionaryAddress = l10nZillaConfigurationProperties.instance().getProperty("dictionaryDBAddress");
        mozDBReader dbReader = null;
        dbReader = new mozDBReader("dummy", dictionaryAddress);
        System.out.println(dbReader.getAllInstallsInDBNames());
    }
}

