/*$Id: config.js,v 1.6 2006/08/21 09:30:10 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var rulesEditEnabled = false;

var sourcesObserver = {
	observe:  function(subject, topic, data){
		refreshRulesList();
	},
	
	QueryInterface: function(iid){
		if ( iid.equals(Components.interfaces.nsIObserver) ||
		     iid.equals(Components.interfaces.nsISupportsWeakReference) ||
		     iid.equals(Components.interfaces.nsISupports))
		return this;
		throw Components.results.NS_NOINTERFACE;
	}	
}

var enabledObserver =
{
	register: function()
	{
		var prefService = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService);
		this.branch = prefService.getBranch("extensions.firekeeper.");
		this.branch.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.branch.addObserver("enabled", this, true);
	},

	unregister: function()
	{
		if(!this.branch) {
			return;
		}
		this.branch.removeObserver("enabled", this);
	},

	observe: function(aSubject, aTopic, aData)
	{
		if(aTopic != "nsPref:changed"){
			return;
		}
		
		
		var checkbox = document.getElementById('enable-checkbox');
		
		var enable = this.branch.getBoolPref("enabled");
		
		if (enable){
			checkbox.setAttribute('checked', 'true');
		}
		else{
			checkbox.setAttribute('checked', 'false');
		}
	},

	QueryInterface: function(iid){
		if ( iid.equals(Components.interfaces.nsIObserver) ||
		     iid.equals(Components.interfaces.nsISupportsWeakReference) ||
		     iid.equals(Components.interfaces.nsISupports))
		return this;
		throw Components.results.NS_NOINTERFACE;
	}	
}

function viewRulesInit()
{
	getServices();
	
	var enabled = Object();
	firekeeper.isEnabled(enabled);
	var checkbox = document.getElementById('enable-checkbox');
	if (enabled.value == true)
		checkbox.setAttribute('checked', 'true');
	else
		checkbox.setAttribute('checked', 'false');
	
	var observerService =
		Components.classes["@mozilla.org/observer-service;1"]
		.getService(Components.interfaces.nsIObserverService);
	observerService.addObserver(sourcesObserver,"rules-sources-changed", true);

	enabledObserver.register();
	refreshRulesList();
	document.getElementById('rules-text').srcidx = -1;
}

function refreshRulesList()
{
	var listbox = document.getElementById('sources-listbox');

	var cnt = listbox.getRowCount();
	for(var i = 0; i < cnt; i++)
		listbox.removeItemAt(0);
	
	var sources = rulesLoader.getRulesSources({});
	
	for(i = 0; i < sources.length; i++){
		var source = sources[i];
		var item;
		if (source.url.substring(0, 7) == "http://"){
			item = listbox.appendItem(source.url, source.name);
		}else
			item = listbox.appendItem(source.name, source.name);
		
		if (source.remote && source.backupAvailable){
			item.setAttribute('tooltiptext', source.url + " document not available" 
					  + " local backup used");
		}
		else
			item.setAttribute('tooltiptext', source.url);
		
		item.setAttribute('id', 'source-listitem');
		item.setAttribute('crop', 'end');
		
		
		if (source.loadError)
			item.setAttribute('status', 'error');
		else if (source.parsingError){
			item.setAttribute('status', 'parse-error');
		}
		else 
			item.setAttribute('status', 'ok');
	}
	displaySelectedSource();
}

function addLocalSource()
{
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"]
		.createInstance(nsIFilePicker);
	fp.init(window, "Select a File", nsIFilePicker.modeOpen);
	var res = fp.show();
	if (res == nsIFilePicker.returnOK){
		var file = fp.file;
		rulesLoader.addLocalSource(file);
	}
}

function addRemoteSource()
{
	window.openDialog('chrome://firekeeper/content/addremotesource.xul', '_blank', 
			  'chrome,resizable,extrachrome,scrollbars,status,toolbar,centerscreen', 
			  rulesLoader);
}

function removeSource()
{
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount)
		return;
	rulesLoader.removeSource(listbox.selectedIndex);
}

function disableRulesEdit()
{
	document.getElementById('savesource-button').
		setAttribute('disabled', 'true');
	document.getElementById('savesource-button').
		setAttribute('tooltiptext', 'Can\'t modify selected file');	
	//document.getElementById('rules-text').
	//setAttribute('readonly', 'true');
}
         
function enableRulesEdit()
{
	document.getElementById('savesource-button').
		setAttribute('disabled', 'false');	
	document.getElementById('savesource-button').
		setAttribute('tooltiptext', 'Save changes');	
	//document.getElementById('rules-text').
	//setAttribute('readonly', 'false');
}


function displaySource(idx)
{
	var sources = rulesLoader.getRulesSources({});
	if (0 > idx || idx >= sources.length){
		return;
	}
	document.getElementById('rules-text').srcidx = idx;
	
	var source = sources[idx];
	if (source.loadError || source.remote){
		disableRulesEdit();
	}else
		enableRulesEdit();
	
	var text = document.getElementById('rules-text');
	if (source.loadError && !source.backupAvailable){
		text.value =  source.loadError;
		text.setAttribute('status', 'error');
	}
	else{
		if (source.remote){
			text.setAttribute('status', 'ok-remote');
			if (source.backupAvailable)
				/*TODO: write some info*/;
		}
		else{
			text.setAttribute('status', 'ok-local');
		}
		text.value = source.rules;
	}
	document.getElementById('parsingerror-text').value = source.parsingError;	

	var rembut = document.getElementById('removesource-button');
	if (source.name == "blacklist" || source.name == "whitelist"){		
		rembut.setAttribute('disabled', 'true');	
		rembut.setAttribute('tooltiptext', 'can\'t remove this file');	
	}		
	else{
		rembut.setAttribute('disabled', 'false');	
		rembut.setAttribute('tooltiptext', 
				    'Removes file from Firekeeper not from disc.');	
	}
}

function displaySelectedSource()
{	
	var listbox = document.getElementById('sources-listbox');
	if (!listbox.selectedCount){
		return;
	}
	displaySource(listbox.selectedIndex);	

}
   
function changeEnable()
{	
	var enable = document.getElementById('enable-checkbox').
		getAttribute('checked');
	
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService);		
	prefs = prefs.getBranch("extensions.firekeeper.");
	if (enable)
		prefs.setBoolPref("enabled", true);
	else
		prefs.setBoolPref("enabled", false);
	firekeeper.enable(enable);
	
}

function reloadSources()
{
	rulesLoader.reloadAllSources();
}

function saveSource()
{
	var idx = document.getElementById('rules-text').srcidx;
	if (idx < 0){
		return;
	}
	rulesLoader.changeLocalSource(idx, document.getElementById('rules-text').value);	
	displaySource(idx);
}
