/*$Id: judge.js,v 1.15 2006/10/12 19:18:18 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

function fkJudge() {
	this.ContractID = JUDGE_CONTRACTID;
	
	this.cid = Components.ID("4f1522b9-8aa1-436a-b3cd-3f087847e2ee");
	
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) || 
		    iid.equals(Components.interfaces
			       .nsISupportsWeakReference)         ||
		    iid.equals(Components.interfaces.fkIJudge)
		    )
		return this;
		
		//dump("Unimplemented fkJudge interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
	
	this.init = function() {
		//Register fkJudge
		Components.manager.QueryInterface(Components.interfaces
						  .nsIComponentRegistrar)
		.registerFactory(this.cid, "Firekeeper Judge", 
				 this.ContractID, new judgeFactory(this));		
	}

	/*fkIJudge*/
	/*Decide what to do when rule is broken.*/
	this.judge = function(url, rule, sentence){
		dump("judge called url = " + url + "fid = " 
		     + rule.fid + "\naction = " 
		     + rule.action + "\nmsg = " + rule.msg + "\n");
		if (rule.action == "drop"){
			sentence.action = sentence.BLOCK;
		}
		else if (rule.action == "pass"){
			sentence.action = sentence.DONT_AUDIT;
		}
		else if (rule.action == "alert"){
			//Ask user what to do.
			//modal rox
			var options = "chrome,modal=yes,resizable,centerscreen";
			window.openDialog("chrome://firekeeper/content/alert.xul",
					  "_blank", options, 
					  url, rule, sentence); 
			
		}
		
	}

}

function judgeFactory(judge){
	this.judge = judge;
	
	/*nsIFactory*/
	this.createInstance = function(outer, iid) {
		if (outer != null){
			dump("Exception outer != null\n");
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		}
		if (iid.equals(Components.interfaces.fkIJudge) ||
		    iid.equals(Components.interfaces.nsISupports)){
			    return this.judge;
		    }
		dump("Exception no interface\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
			 
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) ||
		    iid.equals(Components.interfaces
			       .nsISupportsWeakReference)         ||
		    iid.equals(Components.interfaces.nsIFactory)){
			    return this;
		    }
			
		dump("Unimplemented factory interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
}




