
/*
 *  Copyright (C) 2006 Jan Wrobel
 *  Copyright (C) 2005 Sourcefire,Inc.
 */
#ifndef __STR_SEARCH_H__
#define __STR_SEARCH_H__

/* Function prototypes  */
int  SearchInit(unsigned int num);
int  SearchReInit(unsigned int i);
void SearchFree();
void SearchAdd(unsigned int mpse_id, unsigned char *pat, unsigned int pat_len, 
	       int nocase, int id);
typedef int (*MatchFunction)(void *, int, void *);
int  SearchFindString(unsigned int mpse_id, unsigned char *str, unsigned int str_len, 
		      int (*Match) (void *, int, void *), void *ctx);

typedef struct _search_api
{
	int (*search_init)(unsigned int);

	int (*search_reinit)(unsigned int);

	void (*search_free)();

	void (*search_add)(unsigned int, unsigned char *, unsigned int, int, void *);

	int (*search_find)(unsigned int, unsigned char *, unsigned int, MatchFunction, void *); 
} SearchAPI;

extern SearchAPI *searchAPI;


#endif  /*  __STR_SEARCH_H__  */

