/*$Id: common.js,v 1.2 2006/08/20 16:40:23 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

/*global services*/
var firekeeper = null;
//var firekeeperState = null;
var rulesLoader = null;
var judge = null;

var FIREKEEPER_CONTRACTID = "@firekeeper.mozdev.org/firekeeper";
var RULESLOADER_CONTRACTID = "@firekeeper.mozdev.org/fkrulesloader";
var JUDGE_CONTRACTID = "@firekeeper.mozdev.org/fkjudge";

var debug = {
	console: Components.classes["@mozilla.org/consoleservice;1"].
	getService(Components.interfaces.nsIConsoleService),
	
	msg: function(s){
		this.console.logStringMessage(s);
	},
	
	assert: function(val, str){
		if (!val){
			this.console.logStringMessage("Assertion failed: " + str);
			close();
		}
	}
}

function getServices()
{
	firekeeper  = Components.classes[FIREKEEPER_CONTRACTID];
	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " + 
			"component " + FIREKEEPER_CONTRACTID + 
			" not registered";
		//firekeeperState.changeState("error", errMsg);
		throw(errMsg);
	}
	firekeeper = firekeeper.getService(Components.interfaces.fkIFirekeeper);
	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " +
			"can't obtain fkIFirekeeper interface";
		//firekeeperState.changeState("error", errMsg);
		throw(errMsg);
	}
	
	judge = Components.classes[JUDGE_CONTRACTID];	
	if (judge == null){
		debug.msg("creating judge");
		judge = new fkJudge();
		judge.init();
		firekeeper.setJudge(judge);
	}else
		judge = judge.getService(Components.interfaces.fkIJudge);
	
	rulesLoader = Components.classes[RULESLOADER_CONTRACTID];
	if (rulesLoader == null){
		debug.msg("creating rules loader");
		rulesLoader = new fkRulesLoader();
		rulesLoader.init();
	}else	
		rulesLoader = rulesLoader.getService(Components.interfaces.fkIRulesLoader);
}

