/*$Id: fkCallbacks.h,v 1.5 2007/08/16 12:06:19 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKCALLBACKS_H
#define FKCALLBACKS_H

#include "nsISupports.h"
#include "nsISupportsUtils.h"

#include "nsIWebProgressListener.h"
#include "nsIWebProgress.h"
#include "nsIInterfaceRequestor.h"
#include "nsIProgressEventSink.h"
#include "nsISecurityEventSink.h"
#include "nsIHttpEventSink.h"
#include "nsIChannelEventSink.h"
#include "nsIPrompt.h"
#include "nsIChannel.h"
#include "nsILoadGroup.h"

#include "nsWeakReference.h"

#include "fkICallbacksProxy.h"
#include "Error.h"

class fkCallbacks:  public nsIWebProgressListener
                  , public nsIWebProgress
                  , public nsIProgressEventSink
                  , public nsISecurityEventSink
                  , public nsIInterfaceRequestor
                  , public nsIHttpEventSink
                  , public nsIChannelEventSink
                  , public nsIPrompt
                  , public nsSupportsWeakReference
                  , public fkICallbacksProxy 
{
 public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER
	NS_DECL_NSIWEBPROGRESS
	NS_DECL_NSIPROGRESSEVENTSINK
	NS_DECL_NSISECURITYEVENTSINK
	NS_DECL_NSIINTERFACEREQUESTOR
	NS_DECL_NSIHTTPEVENTSINK
        NS_DECL_NSICHANNELEVENTSINK
        NS_DECL_NSIPROMPT
        NS_DECL_FKICALLBACKSPROXY

	fkCallbacks(nsILoadGroup *loadGroup, nsIInterfaceRequestor *);

	virtual ~fkCallbacks();

	//NS_IMETHODIMP GetNotificationCallbacks(nsIInterfaceRequestor **cb);
	//NS_IMETHODIMP SetNotificationCallbacks(nsIInterfaceRequestor *cb);
private:
	//nsCOMPtr<nsIRequest> fkRequest;
	//nsCOMPtr<nsIChannel> fkChannel;
	
        nsCOMPtr<nsIInterfaceRequestor> origCallbacks;
        nsCOMPtr<nsILoadGroup> parrentGroup;
	
	nsCOMPtr<nsIWebProgressListener> origWebProgressListener;
	nsCOMPtr<nsIWebProgress> origWebProgress;
        nsCOMPtr<nsISecurityEventSink> origSecurityEventSink;
        nsCOMPtr<nsIProgressEventSink> origProgressEventSink;
	nsCOMPtr<nsIHttpEventSink> origHttpEventSink;
	nsCOMPtr<nsIChannelEventSink> origChannelEventSink;
	nsCOMPtr<nsIPrompt> origPrompt;

	void checkResult(nsresult rv, const char *iname){
#ifdef DEBUG
		if (NS_FAILED(rv))
			TRACE("fkCallbacks: can't get reference to %s interface %d",
			      iname, rv);
#endif
	}
};

#endif
