/*$Id: Rule.h,v 1.13 2006/10/06 19:31:40 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULE_H
#define RULE_H

#include "Common.h"

struct Rule;


/*
 * Reference to a web page with details about attack described with a rule
 */
struct reference{
	char *system; /*'url', 'bugtraq', 'cve' etc.*/
	char *refId; /*id of a reference, format depends on a system*/
};

/*
 * Data needed to match regular expressions specified by firekeeper rule
 */
struct RE{
	pcre *re_compiled;    /*compiled RE*/
	pcre_extra *re_extra; /*extra data to speedup matching*/
	char *pattern;        /*RE in oryginal string form, 
				needed only for debugging*/
};

/*
 * Data needed to match *_content: options specified by firekeeper rule
 */
struct PatternMatchData{
	unsigned char *pattern_buf;
	unsigned int pattern_size; 
	int nocase; /*if not 0 ignore case size in this pattern*/

	/*Pointer to a rule that specified this content option.
	  Because all patterns are searched together, this pointer is 
	  needed to find out which rule was actually broken when there is a 
	  match*/
	Rule *parent;
};

/*
  All data related to a rule
 */
struct Rule
{
	/*alert, drop, pass ...*/
	char *action; 

	 /*the same for the same type of actions (ex alert)*/
	int actionID;
	/*value of 'msg:' option*/
	char *msg;
	
	/*lists of regular expressions specified by this rule*/
	list<RE> urlREs;
	list<RE> headersREs;
	list<RE> bodyREs;	

	/*lists of data to match '*_content:' options specified by this rule*/
	list<PatternMatchData> url_content;
	list<PatternMatchData> headers_content;
	list<PatternMatchData> body_content;
	
	/*value of 'reference:' options (multiple references allowed)*/
	list<reference> references;
	
	/*id of this rule*/
	int fid;
	/*revision number*/
	int rev;
	
	Rule();
	~Rule();
	void init();
	void reset();
	
	bool urlRule() const;
	bool headersRule() const;
	bool bodyRule() const;
};

#endif
