/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
  gspell plugin for Chatzilla. Javascript Spelling Suggestion using the google Web Services API in conjunction with SOAP for ChatZilla.
  Copyright (C) 2004  Joseph A Hanson

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//Joseph Hanson
//9-16-04 7:00pm
//gSpell - Javascript Spelling Suggestion using the google Web Services API in conjunction with SOAP for ChatZilla.
//Thanks to: I couldn't have done any of this without Silver in #Chatzilla. I'd also like to thank Toast and RetroJ.
//Endpoint: http://api.google.com/search/beta2

var googleApiKey = "00000000000000000000000000000000";
initGSHandlers();

function initPlugin(glob) {
	plugin.id = "gspell-jah";
	plugin.major = 0;  // Major version number.
	plugin.minor = 4;  // Minor version number.
	plugin.version = plugin.major + "." + plugin.minor;
	plugin.description = "|Usage: ctrl+/ | Javascript Spelling Suggestion using the google Web Services API in conjunction with SOAP for ChatZilla.";
	
	plugin.cmdlist = [
		["spell", cmdGoogleSpell, CMD_CONSOLE | CMD_NO_HELP, "<rest>"]
	];
	client.commandManager.defineCommands(plugin.cmdlist);
}

function initGSHandlers()
{
	var node;
	node = document.getElementById("input");
	node.addEventListener("keypress", onGSInputKeyPress, false);
//	node = document.getElementById("multiline-input");
// node.addEventListener("keypress", onMultilineInputKeyPress, false);
//	node.active = false;
}

function onGSInputKeyPress (e)
{
	if (e.charCode == 47 && e.ctrlKey ) /* Forward Slash / */
	{
		var params = new Array();
		var spellWord = e.target.value;
		
		params[0] = new SOAPParameter( googleApiKey, "key" );
		params[1] = new SOAPParameter( spellWord, "phrase" );
		callGoogle( "doSpellingSuggestion", params, parseResult );
		e.preventDefault();
	}
}
function cmdGoogleSpell(e)
{
	var params = new Array();
	var spellWord = e.rest;
	
	params[0] = new SOAPParameter( googleApiKey, "key" );
	params[1] = new SOAPParameter( spellWord, "phrase" );
	callGoogle( "doSpellingSuggestion", params, parseResult );
}
function callGoogle( method, params, callback ) 
{
  try {
	 netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
  } catch (e) {
    alert(e);
    return false;
  }
  var soapCall = new SOAPCall();
  soapCall.transportURI = "http://api.google.com/search/beta2";
  soapCall.encode(0, method, "urn:GoogleSearch", 0, null, params.length, params);
  soapCall.asyncInvoke(
    function (response, soapcall, error)
     {
        var r = handleSOAPResponse(response,soapcall,error );
        callback(r);
      }
  );
}

function handleSOAPResponse (response,call,error)
{
    if (error != 0)
    { 
        alert("Service failure");
        return false;
    } else 
    {
        var fault = response.fault; 
        if (fault != null) { 
            var code = fault.faultCode; 
            var msg = fault.faultString; 
            alert("SOAP Fault:\n\n" +
                "Code: "  + code +
                "\n\nMessage: " + msg
            );
            return false;
        } else 
        {
            return response;
        }
    }
}

function parseResult(result)
{
    if (result==false)
    {
	 		alert("parseResult: False");
         return;
    }
    var num = new Object();
    var params = result.getParameters(false,num);
	 var suggestion = params[0].value;
	 
	 if ( suggestion == null )
	 	display("No Suggestion Available.");
	 else
	 	display("*Suggested spelling* : " + suggestion);
}