/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import sun.io.CharToByteConverter;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBatchUpdateException;
import sun.jdbc.odbc.JdbcOdbcBoundArrayOfParams;
import sun.jdbc.odbc.JdbcOdbcBoundParam;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected int numParams;
    protected JdbcOdbcBoundParam[] boundParams;
    protected JdbcOdbcBoundArrayOfParams arrayParams;
    protected Vector batchSqlVec;
    protected boolean batchSupport;
    protected boolean batchParamsOn;
    protected int batchSize;
    protected int arrayDef;
    protected int arrayScale;
    protected int StringDef;
    protected int NumberDef;
    protected int NumberScale;
    protected int batchRCFlag;
    protected int[] paramsProcessed;
    protected int[] paramStatusArray;

    public JdbcOdbcPreparedStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n, int n2, Hashtable hashtable, int n3, int n4) throws SQLException {
        super.initialize(jdbcOdbc, n, n2, hashtable, n3, n4);
    }

    public ResultSet executeQuery() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeQuery");
        }
        ResultSet resultSet = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeQuery (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeUpdate");
        }
        int n = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    public int executeUpdate(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeUpdate (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public boolean execute(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.execute (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public synchronized boolean execute() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.execute");
        }
        boolean bl = false;
        SQLWarning sQLWarning = null;
        boolean bl2 = false;
        this.clearWarnings();
        this.reset();
        try {
            bl2 = this.OdbcApi.SQLExecute(this.hStmt);
            while (bl2) {
                int n = this.OdbcApi.SQLParamData(this.hStmt);
                if (n == -1) {
                    bl2 = false;
                    continue;
                }
                if (this.batchParamsOn) {
                    InputStream inputStream = null;
                    int n2 = this.paramsProcessed[0];
                    inputStream = this.arrayParams.getInputStreamElement(n, n2);
                    this.boundParams[n - 1].setInputStream(inputStream, this.arrayParams.getElementLength(n, n2));
                }
                this.putParamData(n);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.getColumnCount() > 0) {
            bl = true;
        }
        return bl;
    }

    public void setNull(int n, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.setNull (" + n + "," + n2 + ")");
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.getLengthBuf(n);
        int[] nArray = new int[]{0, 0};
        int n3 = 0;
        int n4 = 0;
        if (n2 == 1 || n2 == 12) {
            n3 = this.StringDef;
        } else if (n2 == 2 || n2 == 3) {
            n3 = this.NumberDef;
            n4 = this.NumberScale;
        }
        if (n3 <= 0) {
            n3 = this.getPrecision(n2);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterNull(this.hStmt, n, n2, n3, n4, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].scale = n4;
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = null;
        this.arrayParams.storeValue(n - 1, null, -1);
        this.setSqlType(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, -7, n2, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = -7;
        this.boundParams[n - 1].boundValue = new Boolean(bl);
        this.arrayParams.storeValue(n - 1, new Boolean(bl), 0);
        this.setSqlType(n, -7);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, -6, by, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = -6;
        this.boundParams[n - 1].boundValue = new Byte(by);
        this.arrayParams.storeValue(n - 1, new Byte(by), 0);
        this.setSqlType(n, -6);
    }

    public void setShort(int n, short s) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 5, s, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 5;
        this.boundParams[n - 1].boundValue = new Short(s);
        this.arrayParams.storeValue(n - 1, new Short(s), 0);
        this.setSqlType(n, 5);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 4, n2, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 4;
        this.boundParams[n - 1].boundValue = new Integer(n2);
        this.arrayParams.storeValue(n - 1, new Integer(n2), 0);
        this.setSqlType(n, 4);
    }

    public void setLong(int n, long l) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, -5, 0, l, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = -5;
        this.boundParams[n - 1].boundValue = new Float(l);
        this.arrayParams.storeValue(n - 1, new Float(l), 0);
        this.setSqlType(n, -5);
    }

    public void setReal(int n, float f) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, 7, 0, f, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.arrayParams.storeValue(n - 1, new Float(f), 0);
        this.setSqlType(n, 7);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, 6, 0, f, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 6;
        this.boundParams[n - 1].boundValue = new Float(f);
        this.arrayParams.storeValue(n - 1, new Float(f), 0);
        this.setSqlType(n, 6);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDouble(this.hStmt, n, 8, 0, d, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 8;
        this.boundParams[n - 1].boundValue = new Double(d);
        this.arrayParams.storeValue(n - 1, new Double(d), 0);
        this.setSqlType(n, 8);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n);
        if (bigDecimal == null) {
            this.setNull(n, 2);
        } else {
            this.setChar(n, 2, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n - 1].boundType = 2;
        this.boundParams[n - 1].boundValue = bigDecimal;
    }

    public void setDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n);
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.setChar(n, 3, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n - 1].boundType = 3;
        this.boundParams[n - 1].boundValue = bigDecimal;
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 1);
        } else if (string.length() >= 254) {
            this.setChar(n, 12, 0, string);
        } else {
            this.setChar(n, 1, 0, string);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
        } else if (byArray.length > 8000) {
            this.setBinaryStream(n, new ByteArrayInputStream(byArray), byArray.length);
        } else {
            this.setBinary(n, -2, byArray);
        }
        this.boundParams[n - 1].boundType = -2;
        this.boundParams[n - 1].boundValue = byArray;
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDate(this.hStmt, n, date, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 91;
        this.boundParams[n - 1].boundValue = date;
        this.arrayParams.storeValue(n - 1, date, -3);
        this.setSqlType(n, 91);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTime(this.hStmt, n, time, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 92;
        this.boundParams[n - 1].boundValue = time;
        this.arrayParams.storeValue(n - 1, time, -3);
        this.setSqlType(n, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTimestamp(this.hStmt, n, timestamp, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundValue = timestamp;
        this.boundParams[n - 1].boundType = 93;
        this.arrayParams.storeValue(n - 1, timestamp, -3);
        this.setSqlType(n, 93);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 1);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -4, 3);
    }

    public void clearParameters() throws SQLException {
        if (this.hStmt != 0) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 3);
            this.FreeParams();
            int n = 1;
            while (n <= this.boundParams.length) {
                this.boundParams[n - 1].binaryData = null;
                this.boundParams[n - 1].initialize();
                this.boundParams[n - 1].paramInputStream = null;
                this.boundParams[n - 1].inputParameter = false;
                ++n;
            }
        }
    }

    public void clearParameter(int n) throws SQLException {
        if (this.hStmt != 0) {
            if (this.boundParams[n - 1].pA1 != 0) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                this.boundParams[n - 1].pA1 = 0;
                this.boundParams[n - 1].pA2 = 0;
            }
            if (this.boundParams[n - 1].pB1 != 0) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                this.boundParams[n - 1].pB1 = 0;
                this.boundParams[n - 1].pB2 = 0;
            }
            if (this.boundParams[n - 1].pC1 != 0) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                this.boundParams[n - 1].pC1 = 0;
                this.boundParams[n - 1].pC2 = 0;
            }
            if (this.boundParams[n - 1].pS1 != 0) {
                JdbcOdbc.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                this.boundParams[n - 1].pS1 = 0;
                this.boundParams[n - 1].pS2 = 0;
            }
            this.boundParams[n - 1].binaryData = null;
            this.boundParams[n - 1].initialize();
            this.boundParams[n - 1].paramInputStream = null;
            this.boundParams[n - 1].inputParameter = false;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, JdbcOdbcStatement.getTypeFromObject(object));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        try {
            switch (n2) {
                case 1: {
                    this.setString(n, (String)object);
                    break;
                }
                case 12: {
                    this.setChar(n, n2, 0, (String)object);
                    break;
                }
                case -1: {
                    this.setChar(n, n2, 0, (String)object);
                    break;
                }
                case 2: {
                    this.setBigDecimal(n, (BigDecimal)object);
                    break;
                }
                case 3: {
                    this.setDecimal(n, (BigDecimal)object);
                    break;
                }
                case -7: {
                    this.setBoolean(n, (Boolean)object);
                    break;
                }
                case -6: {
                    this.setByte(n, (Byte)object);
                    break;
                }
                case 5: {
                    this.setShort(n, (Short)object);
                    break;
                }
                case 4: {
                    this.setInt(n, (Integer)object);
                    break;
                }
                case -5: {
                    this.setLong(n, (Long)object);
                    break;
                }
                case 7: {
                    this.setReal(n, ((Float)object).floatValue());
                    break;
                }
                case 6: {
                    this.setFloat(n, ((Float)object).floatValue());
                    break;
                }
                case 8: {
                    this.setDouble(n, (Double)object);
                    break;
                }
                case -2: {
                    this.setBytes(n, (byte[])object);
                    break;
                }
                case -4: 
                case -3: {
                    byte[] byArray = (byte[])object;
                    if (byArray.length > 8000) {
                        this.setBinaryStream(n, new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    this.setBinary(n, n2, byArray);
                    break;
                }
                case 91: {
                    this.setDate(n, (Date)object);
                    break;
                }
                case 92: {
                    this.setTime(n, (Time)object);
                    break;
                }
                case 93: {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("Object type and JDBC SQL type mismatch. " + classCastException.getMessage());
        }
    }

    public void addBatch(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.addBatch (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void clearBatch() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.clearBatch");
        }
        try {
            if (this.batchSqlVec != null) {
                this.cleanUpBatch();
                this.batchOn = false;
                this.batchParamsOn = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addBatch() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.addBatch");
        }
        try {
            int n;
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec == null) {
                this.batchSqlVec = new Vector(5, 10);
                n = 0;
            } else {
                n = this.batchSqlVec.size();
            }
            Object[] objectArray = this.arrayParams.getStoredParameterSet();
            int[] nArray = this.arrayParams.getStoredIndexSet();
            int n2 = objectArray.length;
            int n3 = nArray.length;
            if (n3 == this.numParams) {
                this.batchSqlVec.addElement(objectArray);
                this.myConnection.setBatchVector(this.batchSqlVec, this);
                this.arrayParams.storeRowIndex(n, nArray);
                this.batchOn = true;
            } else {
                if (n == 0) {
                    throw new SQLException("Parameter-Set has missing values.");
                }
                this.batchOn = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.batchOn = false;
        }
    }

    public int[] executeBatchUpdate() throws BatchUpdateException {
        int[] nArray;
        block21: {
            nArray = new int[]{};
            if (this.numParams <= 0) {
                this.batchSize = 0;
                this.batchOn = false;
                this.batchParamsOn = false;
                return this.executeNoParametersBatch();
            }
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec == null) {
                nArray = new int[]{};
                return nArray;
            }
            this.batchSize = this.batchSqlVec.size();
            if (this.batchSize > 0) {
                nArray = new int[this.batchSize];
                this.paramStatusArray = new int[this.batchSize];
                this.paramsProcessed = new int[this.batchSize];
                try {
                    this.OdbcApi.SQLSetStmtAttr(this.hStmt, 18, 0, 0);
                    int n = 0;
                    try {
                        this.setStmtParameterSize(this.batchSize);
                        n = this.getStmtParameterAttr(22);
                    }
                    catch (SQLException sQLException) {
                        this.batchSupport = false;
                    }
                    if (n != this.batchSize) {
                        this.batchSupport = false;
                        try {
                            this.setStmtParameterSize(1);
                        }
                        catch (SQLException sQLException) {}
                    } else {
                        this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 20, this.paramStatusArray, 0);
                        this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 21, this.paramsProcessed, 0);
                        this.batchSupport = true;
                    }
                }
                catch (SQLException sQLException) {
                    this.batchSupport = false;
                }
                if (this.batchSupport) {
                    this.batchParamsOn = true;
                    int[] nArray2 = new int[]{};
                    this.arrayParams.builtColumWiseParameteSets(this.batchSize, this.batchSqlVec);
                    int n = 0;
                    while (n < this.numParams) {
                        this.arrayDef = 0;
                        this.arrayScale = 0;
                        int n2 = 0;
                        int n3 = n + 1;
                        try {
                            Object[] objectArray = this.arrayParams.getColumnWiseParamSet(n3);
                            int[] nArray3 = this.arrayParams.getColumnWiseIndexArray(n3);
                            this.setPrecisionScaleArgs(objectArray, nArray3);
                            n2 = this.getSqlType(n3);
                            this.bindArrayOfParameters(n3, n2, this.arrayDef, this.arrayScale, objectArray, nArray3);
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                        ++n;
                    }
                    try {
                        if (!this.execute()) {
                            this.paramStatusArray[0] = this.getUpdateCount();
                            this.arrayParams.clearStoredRowIndexs();
                            nArray = this.paramStatusArray;
                            this.batchOn = false;
                            this.batchParamsOn = false;
                            this.cleanUpBatch();
                            break block21;
                        }
                        this.cleanUpBatch();
                        throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", this.paramStatusArray);
                    }
                    catch (SQLException sQLException) {
                        try {
                            this.paramStatusArray[0] = this.getUpdateCount();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                        nArray2 = new int[this.paramsProcessed[0] - 1];
                        this.cleanUpBatch();
                        throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
                    }
                }
                if (!this.batchSupport) {
                    this.batchOn = false;
                    this.batchParamsOn = false;
                    return this.emulateExecuteBatch();
                }
            }
        }
        return nArray;
    }

    protected int[] executeNoParametersBatch() throws BatchUpdateException {
        int[] nArray = new int[1];
        try {
            if (this.execute()) {
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray);
            }
            this.cleanUpBatch();
            nArray[0] = this.getUpdateCount();
        }
        catch (SQLException sQLException) {
            try {
                nArray[0] = this.getUpdateCount();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.cleanUpBatch();
            throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray);
        }
        return nArray;
    }

    protected int getStmtParameterAttr(int n) throws SQLException {
        try {
            this.clearWarnings();
            return this.OdbcApi.SQLGetStmtAttr(this.hStmt, n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return -1;
        }
    }

    protected void setStmtParameterSize(int n) throws SQLException {
        try {
            this.clearWarnings();
            this.OdbcApi.SQLSetStmtAttr(this.hStmt, 22, n, 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected void bindArrayOfParameters(int n, int n2, int n3, int n4, Object[] objectArray, int[] nArray) throws SQLException {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n, n2, objectArray, n3, n4, nArray);
                break;
            }
            case -1: {
                if (this.getTypeFromObjectArray(objectArray) == -4) {
                    this.arrayParams.setInputStreamElements(n, objectArray);
                    this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n, n2, n3, nArray);
                    break;
                }
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n, n2, objectArray, n3, n4, nArray);
                break;
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.OdbcApi.SQLBindInParameterIntegerArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case 8: {
                this.OdbcApi.SQLBindInParameterDoubleArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case -5: 
            case 6: 
            case 7: {
                this.OdbcApi.SQLBindInParameterFloatArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case 91: {
                this.OdbcApi.SQLBindInParameterDateArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case 92: {
                this.OdbcApi.SQLBindInParameterTimeArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case 93: {
                this.OdbcApi.SQLBindInParameterTimestampArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case -3: 
            case -2: {
                this.OdbcApi.SQLBindInParameterBinaryArray(this.hStmt, n, n2, objectArray, n3, nArray);
                break;
            }
            case -4: {
                this.arrayParams.setInputStreamElements(n, objectArray);
                this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n, n2, n3, nArray);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int[] emulateExecuteBatch() throws BatchUpdateException {
        var1_1 = new int[this.batchSize];
        var2_2 = new int[]{};
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < this.batchSize) {
            block23: {
                var5_5 = (Object[])this.batchSqlVec.elementAt(var4_4);
                var6_6 = this.arrayParams.getStoredRowIndex(var4_4);
                try {
                    var7_7 = 0;
                    while (var7_7 < var5_5.length) {
                        var8_11 = 1111;
                        var9_12 = 0;
                        var10_13 = 0;
                        var11_14 = var7_7 + 1;
                        var12_15 = null;
                        var8_11 = JdbcOdbcStatement.getTypeFromObject(var5_5[var7_7]);
                        var13_16 = this.getSqlType(var11_14);
                        if (var8_11 == -4) {
                            var12_15 = (InputStream)var5_5[var7_7];
                            var9_12 = var6_6[var7_7];
                            switch (var13_16) {
                                case -4: {
                                    var10_13 = 3;
                                    break;
                                }
                                case -1: {
                                    var10_13 = this.boundParams[var7_7].getStreamType();
                                }
                            }
                        }
                        if (var9_12 > 0 && 0 < var10_13) {
                            switch (var10_13) {
                                case 1: 
                                case 2: {
                                    this.setStream(var11_14, var12_15, var9_12, -1, var10_13);
                                    break;
                                }
                                case 3: {
                                    this.setStream(var11_14, var12_15, var9_12, -4, var10_13);
                                }
                            }
                        } else if (var8_11 != 1111) {
                            if (var8_11 != 0) {
                                this.setObject(var11_14, var5_5[var7_7], var13_16);
                            } else {
                                this.setNull(var11_14, var13_16);
                            }
                        }
                        ++var7_7;
                    }
                }
                catch (Exception var7_8) {
                    var7_8.printStackTrace();
                }
                try {
                    if (!this.execute()) {
                        this.myConnection.removeBatchVector(this);
                        var1_1[var4_4] = this.getUpdateCount();
                        ++var3_3;
                        break block23;
                    }
                    var7_9 = 0;
                    while (var7_9 < var4_4 - 1) {
                        var2_2 = new int[var3_3];
                        var2_2[var7_9] = var1_1[var7_9];
                        ++var7_9;
                    }
                    this.cleanUpBatch();
                    throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", var2_2);
                }
                catch (SQLException var7_10) {
                    var8_11 = 0;
                    ** while (var8_11 < var4_4 - 1)
                }
lbl-1000:
                // 1 sources

                {
                    var2_2 = new int[var3_3];
                    var2_2[var8_11] = var1_1[var8_11];
                    ++var8_11;
                    continue;
                }
lbl66:
                // 1 sources

                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException(var7_10.getMessage(), var7_10.getSQLState(), var2_2);
            }
            ++var4_4;
        }
        this.cleanUpBatch();
        return var1_1;
    }

    protected void cleanUpBatch() {
        this.myConnection.removeBatchVector(this);
        if (this.batchSqlVec != null) {
            this.batchSqlVec.setSize(0);
            this.batchSize = 0;
        }
    }

    protected void setPrecisionScaleArgs(Object[] objectArray, int[] nArray) {
        int n = this.getTypeFromObjectArray(objectArray);
        int n2 = 0;
        while (n2 < this.batchSize) {
            byte[] byArray = null;
            String string = null;
            BigDecimal bigDecimal = null;
            int n3 = 0;
            try {
                if (n == 3 || n == 2) {
                    if (objectArray[n2] != null) {
                        int n4 = 0;
                        bigDecimal = (BigDecimal)objectArray[n2];
                        string = bigDecimal.toString();
                        n3 = string.indexOf(46);
                        if (n3 == -1) {
                            n3 = string.length();
                        } else {
                            n4 = bigDecimal.scale();
                            n3 += n4 + 1;
                        }
                        if (n4 > this.arrayScale) {
                            this.arrayScale = n4;
                        }
                    }
                } else if (n == 1 || n == 12) {
                    if (objectArray[n2] != null) {
                        string = (String)objectArray[n2];
                        n3 = string.length();
                    }
                } else if (n == -4) {
                    if (nArray[n2] > this.arrayDef) {
                        this.arrayDef = nArray[n2];
                    }
                } else if ((n == -2 || n == -3) && objectArray[n2] != null) {
                    byArray = (byte[])objectArray[n2];
                    n3 = byArray.length;
                }
                if (n3 > this.arrayDef) {
                    this.arrayDef = n3;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    protected void setSqlType(int n, int n2) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setSqlType(n2);
        }
    }

    protected int getSqlType(int n) {
        int n2 = 1111;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.boundParams[n - 1].getSqlType();
        }
        return n2;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.clearParameter(n);
        BufferedReader bufferedReader = null;
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.OdbcApi.charSet;
        int n3 = 300;
        if (n2 < n3) {
            n3 = n2;
        }
        int n4 = 0;
        int n5 = 0;
        try {
            CharToByteConverter charToByteConverter = CharToByteConverter.getConverter(string);
            n5 = charToByteConverter.getMaxBytesPerChar();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (n5 == 0) {
            n5 = 1;
        }
        try {
            if (reader != null) {
                boolean bl = false;
                int n6 = 0;
                bufferedReader = new BufferedReader(reader);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                char[] cArray = new char[n3];
                while (n6 != -1) {
                    byte[] byArray = new byte[]{};
                    n6 = bufferedReader.read(cArray);
                    if (n6 == -1) continue;
                    char[] cArray2 = new char[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        cArray2[n7] = cArray[n7];
                        ++n7;
                    }
                    byArray = this.CharsToBytes(string, cArray2);
                    int n8 = byArray.length - 1;
                    bufferedOutputStream.write(byArray, 0, n8);
                    bufferedOutputStream.flush();
                }
                n4 = byteArrayOutputStream.size();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + iOException.getMessage());
        }
        this.setStream(n, byteArrayInputStream, n4, 12, 3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.getMetaData");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (this.hStmt == 0) {
            throw new SQLException("Statement is closed");
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, null);
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, jdbcOdbcResultSet);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        calendar.setTime(date);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarDate(this.hStmt, n, calendar, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 91;
        this.boundParams[n - 1].boundValue = date;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 91);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        calendar.setTime(time);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTime(this.hStmt, n, calendar, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 92;
        this.boundParams[n - 1].boundValue = time;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        calendar.setTime(timestamp);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTimestamp(this.hStmt, n, calendar, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].boundType = 93;
        this.boundParams[n - 1].boundValue = timestamp;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 93);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void initBoundParam() throws SQLException {
        this.numParams = this.OdbcApi.SQLNumParams(this.hStmt);
        if (this.numParams > 0) {
            this.boundParams = new JdbcOdbcBoundParam[this.numParams];
            int n = 0;
            while (n < this.numParams) {
                this.boundParams[n] = new JdbcOdbcBoundParam();
                this.boundParams[n].initialize();
                ++n;
            }
            this.arrayParams = new JdbcOdbcBoundArrayOfParams(this.numParams);
            this.batchRCFlag = this.myConnection.getBatchRowCountFlag(1);
            this.batchSupport = this.batchRCFlag > 0 && this.batchRCFlag == 1;
            this.StringDef = 0;
            this.NumberDef = 0;
            this.NumberDef = 0;
        }
    }

    protected byte[] allocBindBuf(int n, int n2) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].allocBindDataBuffer(n2);
        }
        return byArray;
    }

    protected byte[] getDataBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindDataBuffer();
        }
        return byArray;
    }

    protected byte[] getLengthBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindLengthBuffer();
        }
        return byArray;
    }

    public int getParamLength(int n) {
        int n2 = -1;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.OdbcApi.bufferToInt(this.boundParams[n - 1].getBindLengthBuffer());
        }
        return n2;
    }

    protected void putParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 2000;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        if (n < 1 || n > this.numParams) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Invalid index for putParamData()");
            }
            return;
        }
        InputStream inputStream = this.boundParams[n - 1].getInputStream();
        int n3 = this.boundParams[n - 1].getInputStreamLen();
        int n4 = this.boundParams[n - 1].getStreamType();
        while (!bl) {
            int n5;
            try {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Reading from input stream");
                }
                n5 = inputStream.read(byArray);
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Bytes read: " + n5);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n5 == -1) {
                if (n3 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl = true;
                break;
            }
            if (n5 > n3) {
                n5 = n3;
                bl = true;
            }
            int n6 = n5;
            if (n4 == 2) {
                n6 = n5 / 2;
                int n7 = 0;
                while (n7 < n6) {
                    byArray[n7] = byArray[n7 * 2 + 1];
                    ++n7;
                }
            }
            this.OdbcApi.SQLPutData(this.hStmt, byArray, n6);
            n3 -= n5;
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("" + n3 + " bytes remaining");
            }
            if (n3 != 0) continue;
            bl = true;
        }
    }

    public void setStream(int n, InputStream inputStream, int n2, int n3, int n4) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.getLengthBuf(n);
        byte[] byArray2 = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0, 0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterAtExec(this.hStmt, n, n3, n2, byArray2, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
        this.boundParams[n - 1].boundType = n3;
        this.boundParams[n - 1].boundValue = inputStream;
        this.boundParams[n - 1].setInputStream(inputStream, n2);
        this.boundParams[n - 1].setStreamType(n4);
        this.arrayParams.storeValue(n - 1, inputStream, n2);
        this.setSqlType(n, n3);
    }

    protected void setChar(int n, int n2, int n3, String string) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        int n4 = 0;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{};
        try {
            byArray = this.CharsToBytes(this.OdbcApi.charSet, cArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = this.allocBindBuf(n, byArray.length);
        n4 = this.getPrecision(n2);
        if (n4 < 0 || n4 > 8000) {
            n4 = byArray.length;
        }
        int[] nArray = new int[]{0, 0, 0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterString(this.hStmt, n, n2, n4, n3, byArray, byArray2, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
        this.boundParams[n - 1].scale = n3;
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = string;
        if (n2 == 2 || n2 == 3) {
            this.arrayParams.storeValue(n - 1, new BigDecimal(string.trim()), -3);
            this.NumberDef = n4;
            if (n3 > this.NumberScale) {
                this.NumberScale = n3;
            }
        } else {
            this.arrayParams.storeValue(n - 1, string, -3);
            this.StringDef = n4;
        }
        this.setSqlType(n, n2);
    }

    protected void setBinary(int n, int n2, byte[] byArray) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray2 = this.allocBindBuf(n, byArray.length);
        byte[] byArray3 = this.getLengthBuf(n);
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterBinary(this.hStmt, n, n2, byArray, byArray2, byArray3, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
        this.boundParams[n - 1].pC1 = nArray[4];
        this.boundParams[n - 1].pC2 = nArray[5];
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = byArray;
        this.arrayParams.storeValue(n - 1, byArray, -3);
        this.setSqlType(n, n2);
    }

    protected int getTypeFromObjectArray(Object[] objectArray) {
        int n = 1111;
        int n2 = 0;
        while (n2 < this.batchSize) {
            n = JdbcOdbcStatement.getTypeFromObject(objectArray[n2]);
            if (n != 0) break;
            ++n2;
        }
        return n;
    }

    public synchronized void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
                this.FreeParams();
                int n = 1;
                while (this.boundParams != null && n <= this.boundParams.length) {
                    this.boundParams[n - 1].binaryData = null;
                    this.boundParams[n - 1].initialize();
                    this.boundParams[n - 1].paramInputStream = null;
                    this.boundParams[n - 1].inputParameter = false;
                    ++n;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.myConnection.deregisterStatement(this);
        if (this.batchOn) {
            this.clearBatch();
        }
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            int n = 1;
            while (n <= this.boundParams.length) {
                if (this.boundParams[n - 1].pA1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                    this.boundParams[n - 1].pA1 = 0;
                    this.boundParams[n - 1].pA2 = 0;
                }
                if (this.boundParams[n - 1].pB1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                    this.boundParams[n - 1].pB1 = 0;
                    this.boundParams[n - 1].pB2 = 0;
                }
                if (this.boundParams[n - 1].pC1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                    this.boundParams[n - 1].pC1 = 0;
                    this.boundParams[n - 1].pC2 = 0;
                }
                if (this.boundParams[n - 1].pS1 != 0) {
                    JdbcOdbc.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                    this.boundParams[n - 1].pS1 = 0;
                    this.boundParams[n - 1].pS2 = 0;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setSql(String string) {
        this.mySql = string.toUpperCase();
    }

    public Object[] getObjects() {
        Object[] objectArray = new Object[this.numParams];
        Object[] objectArray2 = this.arrayParams.getStoredParameterSet();
        if (objectArray2 != null) {
            try {
                int n = 0;
                while (n < this.numParams) {
                    objectArray[n] = objectArray2[n];
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Exception, while calculating row count: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public int[] getObjectTypes() {
        int[] nArray = new int[this.numParams];
        int n = 0;
        while (n < this.numParams) {
            nArray[n] = this.boundParams[n].getSqlType();
            ++n;
        }
        return nArray;
    }

    public int getParamCount() {
        return this.numParams;
    }

    protected void setInputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setInputParameter(bl);
        }
    }
}

