/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public abstract class WindowsTextUI
extends BasicTextUI {
    static LayeredHighlighter.LayerPainter WindowsPainter = new WindowsHighlightPainter(null);

    protected Caret createCaret() {
        return new WindowsCaret();
    }

    static class WindowsHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        WindowsHighlightPainter(Color color) {
            super(color);
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                int n3;
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                boolean bl = false;
                boolean bl2 = false;
                if (jTextComponent.isEditable()) {
                    n3 = jTextComponent.getCaretPosition();
                    bl = n == n3;
                    boolean bl3 = bl2 = n2 == n3;
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    if (rectangle4.width > 0) {
                        if (bl) {
                            ++rectangle4.x;
                            --rectangle4.width;
                        } else if (bl2) {
                            --rectangle4.width;
                        }
                    }
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    n3 = rectangle.x + rectangle.width - rectangle2.x;
                    if (bl && n3 > 0) {
                        ++rectangle2.x;
                        --n3;
                    }
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    if (bl2 && rectangle3.x > rectangle.x) {
                        --rectangle3.x;
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (jTextComponent.isEditable()) {
                int n3 = jTextComponent.getCaretPosition();
                bl = n == n3;
                boolean bl3 = bl2 = n2 == n3;
            }
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            try {
                Rectangle rectangle;
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    static class WindowsCaret
    extends DefaultCaret
    implements UIResource {
        WindowsCaret() {
        }

        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsPainter;
        }
    }
}

