/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.History;
import org.mozilla.webclient.HistoryEntry;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;

public class HistoryImpl
extends ImplObjectNative
implements History {
    public HistoryImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
    }

    public void back() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeBack(this.nativeWebShell);
        }
    }

    public boolean canBack() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        boolean bl = false;
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            bl = this.nativeCanBack(this.nativeWebShell);
        }
        return bl;
    }

    public HistoryEntry[] getBackList() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Object var1_1 = null;
        throw new UnimplementedException("\nUnimplementedException -----\n API Function History::getBackList has not yet been implemented.\n");
    }

    public void clearHistory() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        throw new UnimplementedException("\nUnimplementedException -----\n API Function History::clearHistory has not yet been implemented.\n");
    }

    public void forward() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeForward(this.nativeWebShell);
        }
    }

    public boolean canForward() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        boolean bl = false;
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            bl = this.nativeCanForward(this.nativeWebShell);
        }
        return bl;
    }

    public HistoryEntry[] getForwardList() {
        Object var1_1 = null;
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        throw new UnimplementedException("\nUnimplementedException -----\n API Function History::getForwardList has not yet been implemented.\n");
    }

    public HistoryEntry[] getHistory() {
        Object var1_1 = null;
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        throw new UnimplementedException("\nUnimplementedException -----\n API Function History::getHistory has not yet been implemented.\n");
    }

    public HistoryEntry getHistoryEntry(int n) {
        ParameterCheck.noLessThan(n, 0);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        Object var2_2 = null;
        throw new UnimplementedException("\nUnimplementedException -----\n API Function History::getHistoryEntry has not yet been implemented.\n");
    }

    public int getCurrentHistoryIndex() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        int n = -1;
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            n = this.nativeGetCurrentHistoryIndex(this.nativeWebShell);
        }
        return n;
    }

    public void setCurrentHistoryIndex(int n) {
        ParameterCheck.noLessThan(n, 0);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeSetCurrentHistoryIndex(this.nativeWebShell, n);
        }
    }

    public int getHistoryLength() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        int n = -1;
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            n = this.nativeGetHistoryLength(this.nativeWebShell);
        }
        return n;
    }

    public String getURLForIndex(int n) {
        ParameterCheck.noLessThan(n, 0);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        String string = null;
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            string = this.nativeGetURLForIndex(this.nativeWebShell, n);
        }
        return string;
    }

    public native void nativeBack(int var1);

    public native boolean nativeCanBack(int var1);

    public native HistoryEntry[] nativeGetBackList(int var1);

    public native void nativeClearHistory(int var1);

    public native void nativeForward(int var1);

    public native boolean nativeCanForward(int var1);

    public native HistoryEntry[] nativeGetForwardList(int var1);

    public native HistoryEntry[] nativeGetHistory(int var1);

    public native HistoryEntry nativeGetHistoryEntry(int var1, int var2);

    public native int nativeGetCurrentHistoryIndex(int var1);

    public native void nativeSetCurrentHistoryIndex(int var1, int var2);

    public native int nativeGetHistoryLength(int var1);

    public native String nativeGetURLForIndex(int var1, int var2);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("HistoryImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: HistoryImpl.java,v 1.5 2001/05/29 18:36:07 ashuk%eng.sun.com Exp $");
    }
}

