/*
** authored by flexer + rue
*/



/*
** Core Routines
*/

// Initializes Window-menu Icons
function cutemenusInit() {
	var menuItems = document.getElementsByTagName("menuitem");
	var iconLabels = [];
	var iconName;
	
	iconLabels["Add to Bookmarks..."] =				"bookmark";
	iconLabels["Back"] =							"back";
	iconLabels["Bookmarks"] =						"bookmark";
	iconLabels["Copy"] =							"copy";
	iconLabels["Customize"] =						"customize";
	iconLabels["Cut"] =								"cut";
	iconLabels["Decrease Text Size"] =				"font-decrease";
	iconLabels["Delete"] =							"delete";
	iconLabels["Downloads"] =						"save";
	iconLabels["Exit"] =							"exit";
	iconLabels["Find in This Page..."] =			"search";
	iconLabels["Forward"] =							"forward";
	iconLabels["Full Screen"] =						"fullscreen";
	iconLabels["Home"] =							"home";
	iconLabels["History"] =							"history";
	iconLabels["Increase Text Size"] =				"font-increase";
	iconLabels["New Tab"] =							"new-tab";
	iconLabels["New Window"] =						"new-window";
	iconLabels["Options..."] =						"options";
	iconLabels["Page Info"] =						"pageinfo";
	iconLabels["Page Source"] =						"source";
	iconLabels["Paste"] =							"paste";
	iconLabels["Print..."] =						"print";
	iconLabels["Redo"] =							"redo";
	iconLabels["Reload"] =							"reload";
	iconLabels["Save Page As..."] =					"save";
	iconLabels["Send Page..."] =					"send";
	iconLabels["Stop"] =							"stop";
	iconLabels["Undo"] =							"undo";
	
	/*Additions using existing images by Aaron Spuler*/
	iconLabels["Send Link..."] =					"send";
    iconLabels["Edit Page"] =						"customize";
    iconLabels["Page Setup..."] =					"source";
    iconLabels["Print Preview"] =					"print";
    iconLabels["Close"]	=							"exit";
    iconLabels["Navigator Window"] =				"new-window";
	iconLabels["Navigator Tab"] =					"new-tab";
	iconLabels["Find Again"] =						"search";
	iconLabels["Find Previous"] =					"search";
	iconLabels["Find Links As You Type"] = 			"search";
	iconLabels["Find Text As You Type"] =			"search";
	iconLabels["Fill in Form"] =					"source";
	iconLabels["Save Form Info"] =					"save";
	iconLabels["Preferences..."] =					"options";
	iconLabels["File Bookmark..."] =				"save";
	iconLabels["Bookmark This Page"] =				"bookmark";
	iconLabels["Bookmark This Group of Tabs..."] =	"bookmark";
	iconLabels["Manage Bookmarks..."] =				"customize";
	iconLabels["Search the Web"] =					"search";
	iconLabels["Download Manager"] =				"save";
	iconLabels["Smaller"] =							"font-decrease";
	iconLabels["Larger"] =							"font-increase";
	iconLabels["Copy Image Location"] =				"copy";
	iconLabels["Copy Link Location"] =				"copy";
	iconLabels["Save Image As..."] =				"save";
	iconLabels["Send Image..."] =					"send";
	iconLabels["Properties"] =						"pageinfo";
	iconLabels["Block Images from this Server"] =	"stop";
	iconLabels["Block Images from this Site"] =		"stop";
	iconLabels["Block Cookies from this Site"] = 	"stop";
	iconLabels["Edit Form Info"] =					"source";
	iconLabels["Manage Sites"] =					"customize";
	iconLabels["Log Out"] =							"stop";
	iconLabels["Manage Stored Passwords"] = 		"customize";
	iconLabels["Manage Popups"] =					"customize";
	iconLabels["Manage Image Permissions"] = 		"customize";
	iconLabels["Manage Stored Cookies"] = 			"customize";
	iconLabels["Preferences"] =						"options";
	iconLabels["Switch Profile..."] =				"exit";
	iconLabels["Help Contents"] =					"source";
	iconLabels["Release Notes"] =					"source";
	iconLabels["About Plug-ins"] =					"pageinfo";
	iconLabels["Open File..."] =					"save";
	iconLabels["Open Web Location..."] =			"bookmark";
	iconLabels["Adblock Image"] =					"stop";
	iconLabels["List All Blockable Elements"] = 	"source";
	iconLabels["Overlay Flash (for right-click)"] =	"stop";
	iconLabels["Show Only This Frame"] =			"search";
	iconLabels["Open Frame in New Window"] =		"new-window";
	iconLabels["Open Frame in New Tab"] =			"new-tab";
	iconLabels["Reload Frame"] =					"reload";
	iconLabels["Bookmark This Frame"] =				"bookmark";
	iconLabels["Save Frame As..."] =				"save";
	iconLabels["Send Frame..."] =					"send";
	iconLabels["View Frame Source"] =				"source";
	iconLabels["View Frame Info"] =					"pageinfo";
	
	/*Composer Window*/
	iconLabels["Save"] =							"save";
	iconLabels["Save As..."] =						"save";
	iconLabels["Save As Charset..."] =				"save";
	iconLabels["Publish"] =							"send";
	iconLabels["Publish As..."] =					"send";
	iconLabels["Revert"] =							"undo";
	iconLabels["Export to Text..."] =				"source";
	iconLabels["Browse Page"] =						"home";
	iconLabels["Send Page..."] =					"send";
	iconLabels["Paste Without Formatting"] =		"paste";
	iconLabels["Find and Replace..."] =				"search";
	iconLabels["Publishing Site Settings..."] =		"options";
	iconLabels["Break Below Image(s)"] =			"stop";
	iconLabels["Discontinue Text Styles"] =			"stop";
	iconLabels["Discontinue Link"] =				"stop";
	iconLabels["Remove Named Anchors"] =			"delete";
	iconLabels["Increase Indent"] =					"forward";
	iconLabels["Decrease Indent"] =					"back";
	iconLabels["Positioning Grid"] =				"customize";
	iconLabels["Break Below Image(s)"] =			"stop";
	iconLabels["Advanced Properties..."] =			"options";
	iconLabels["Page Colors and Background..."] =	"customize";
	iconLabels["Page Title and Properties..."] =	"options";
	iconLabels["Table or Cell Background Color..."]="customize";
	iconLabels["Table Properties..."] =				"options";
	iconLabels["Join with Cell to the Right"] =		"forward";
	iconLabels["Split Cell"] =						"cut";
	
	/*Additions creating new images by Aaron Spuler*/
	iconLabels["View Background Image"] =			"image";
	iconLabels["View Image"] =						"image";
	iconLabels["Set As Wallpaper"] =				"image";
	iconLabels["Text Color..."] =					"image";
	iconLabels["Image..."] =						"image";
	iconLabels["Validate HTML"] =					"allow";
	iconLabels["Check Spelling"] =					"allow";
	iconLabels["About Mozilla"] =					"mozilla";
	iconLabels["About Mozilla Firebird"] = 			"mozilla";
	iconLabels["For Internet Explorer Users"] =		"ie";
	iconLabels["Select All"] =						"select-all";
	iconLabels["Table..."] =						"select-all";
	iconLabels["Link..."] =							"select-all";
	iconLabels["Named Anchor..."] =					"select-all";
	iconLabels["Horizontal Line"] =					"select-all";
	iconLabels["Create Table from Selection"] =		"select-all";	
	iconLabels["Allow Popups From This Site"] =		"allow";
	iconLabels["Allow Images from this Site"] =		"allow";
	iconLabels["Allow Cookies from this Site"] =	"allow";
	iconLabels["Translate Page"] =					"translate";
	iconLabels["HTML..."] =							"translate";
	iconLabels["Characters and Symbols..."] =		"translate";
	
	for (var i = 0; i < menuItems.length; ++i) {
		iconName = iconLabels[menuItems[i].label];
		if (iconName) cutemenusIconify( menuItems[i], iconName ); 
	}
}

// set the cutemenu-attributes for window-menus
function cutemenusIconify(menuitem,iconName){
	menuitem.setAttribute("cutemenus", "true");
	menuitem.setAttribute("cutewindowmenu", "true");
	menuitem.setAttribute("cuteimage", iconName+".png");
}

// Preferences observer object
function cutemenusPrefObserver() {
	try {
		var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
		this.cutemenusBranch = "cutemenus.";
		this.Branch = prefService.getBranch(this.cutemenusBranch);
		
		this.windowInit = false;
		this.cuteItems = null;
		this.enabled = null;
		this.theme = null;
		this.skin = null;
		this.obsrvRe = 	/^cutemenus\.(observer)/;
		this.mainRe = 	/^cutemenus\.(enabled|theme|skin)/;

		var pref = prefService.getBranch(null); // preferences root node
		this.pbi = pref.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
		this.pbi.addObserver(this.cutemenusBranch, this, true); // keep this last, in case we hit an error.
		window.document.addEventListener("load", initCuteMenusPrefObserver, true); // initialize the menu on window-load
	} catch(e) { alert("CuteMenus: prefs-Observer failed to attach: " + e + "\n"); }
}

cutemenusPrefObserver.prototype = {	
	// nsISupports interface implementation -- for weak-reference by pref-observer service
	QueryInterface: function(iid) {
		if (!iid.equals(Components.interfaces.nsISupports)
				&& !iid.equals(Components.interfaces.nsISupportsWeakReference)
				&& !iid.equals(Components.interfaces.nsIObserver)) {
			dump("CuteMenus pef-observer factory object: QI unknown interface: " + iid + "\n");
			throw Components.results.NS_ERROR_NO_INTERFACE; }
		return this;
	},
	
	// removes the observer-object from service -- called when the window is no longer open
	removeObserver: function() {
		this.pbi.removeObserver(this.cutemenusBranch, this);
		delete this;
	},
	
	/* Observer-function */
	/* subject: [wrapped nsISupports :: nsIPrefBranch], nsIPrefBranchInternal
	   topic: "changed"*/
	observe: function(subject, topic, prefName) {

		// if we don't have a valid window (closed)
		if ( !(typeof(document) == 'object' && document) ) {
			this.removeObserver(); // remove the observer..
			return; } // ..and don't continue
		
		// on window-init, OR a status-critical pref change
		if ((!this.windowInit && this.obsrvRe.test(prefName)) || this.mainRe.test(prefName)) {
			
			// Window-init - begin
			if (!this.windowInit) {
				document.getElementById("contentAreaContextMenu").addEventListener("popupshowing", cutemenusSetContext, true); 	// sets the context-menu items
				document.getElementById("contentAreaContextMenu").addEventListener("mousemove", cutemenusSetContext, true);
				
				cutemenusInit(); // initialize window-menu icons
				cutemenusThemeCheck(); // check-for + load 3rd party themes

				// create menuitem pointers: this.cuteItems[]
				this.cuteItems = document.getElementsByAttribute("cutemenus", "true");
				for (var n = 0 ; n < this.cuteItems.length ; n++)
					if (!this.cuteItems[n].hasAttribute("cutewindowmenu"))
						this.cuteItems[n].setAttribute("hidden", "true"); // hide our context-items, so non-mozilla entries don't show
				
				// officeXP-theme "MenuElement" types
				this.cuteArray = new Array();
				this.cuteArray[0] = "menupopup";
				this.cuteArray[1] = "popup";
				this.cuteArray[2] = "menubar";
				this.cuteArray[3] = "menu";
				this.cuteArray[4] = "menuitem";
				this.cuteArray[5] = "menuseparator";
			}

			// Theme-change
			if (!this.windowInit || prefName == "cutemenus.theme") {
				// extract theme name: for element-IDs, later
				var oldThemeName = this.theme ? this.theme.replace(/\.jar\!/i, "").replace(/.*\/([^\/]+)\/$/, "$1") : null;
				this.theme = this.Branch.prefHasUserValue("theme") ? this.Branch.getCharPref("theme") : "chrome://cutemenus/content/default/"; // default:qute-theme
				var newThemeName = this.theme ? this.theme.replace(/\.jar\!/i, "").replace(/.*\/([^\/]+)\/$/, "$1") : null;
				
				// change theme by altering image-attribute -- only if initialized + enabled
				if (this.windowInit && this.enabled)
					for (var t = 0, cuteImageNew ; t < this.cuteItems.length ; t++) {
						cuteImageNew = (this.theme + this.cuteItems[t].getAttribute("cuteimage"));
						this.cuteItems[t].setAttribute("image", cuteImageNew); }
				
				// set context-item checkbox for current theme
				if (oldThemeName) document.getElementById("cutemenus-configtheme-"+oldThemeName).setAttribute("checked", false);
				if (newThemeName) document.getElementById("cutemenus-configtheme-"+newThemeName).setAttribute("checked", true);
			}
	
			// Enabled / Disabled
			if (!this.windowInit || prefName == "cutemenus.enabled") {
				this.enabled = (!this.Branch.prefHasUserValue("enabled") || this.Branch.getBoolPref("enabled")); // default:true
				
				document.getElementById("cutemenus-config-enable").label = this.enabled ? "Disable CuteMenus" : "Enable CuteMenus";
				var cuteCommand = "cutemenusConfig("+ !this.enabled +", null, null);";
				document.getElementById("cutemenus-config-enable").setAttribute("oncommand", cuteCommand);
				var origClass, cuteClass, cuteImage;

				if (this.enabled)
				
					// activate cute-icons
					for (var i = 0 ; i < this.cuteItems.length ; i++) {
						origClass = this.cuteItems[i].hasAttribute("class") ? this.cuteItems[i].getAttribute("class") : null;
						cuteClass = (origClass) ? (origClass+" "+"menuitem-iconic") : ("menuitem-iconic");
						this.cuteItems[i].setAttribute("class", cuteClass);
						this.cuteItems[i].setAttribute("image", this.theme + this.cuteItems[i].getAttribute("cuteimage")); }

				// if we're disabled, and already initialized the items
				else if (this.windowInit)
				
					// deactivate cute-icons
					for (var m = 0 ; m < this.cuteItems.length ; m++) {
						origClass = this.cuteItems[m].getAttribute("class").replace(/ ?menuitem\-iconic/, '');
						if (origClass) this.cuteItems[m].setAttribute("class", origClass);
						else this.cuteItems[m].removeAttribute("class");
						this.cuteItems[m].removeAttribute("image"); }
						
			}

			// Set OfficeXP Skin
			if (!this.windowInit || prefName == "cutemenus.skin" || prefName == "cutemenus.enabled") {
				this.skin = (!this.Branch.prefHasUserValue("skin") || this.Branch.getBoolPref("skin")); // default:true
				
				if (prefName != "cutemenus.enabled") {
					var cuteSkinCommand = "event.preventDefault(); event.stopPropagation(); cutemenusConfig(" 
							+ (this.skin ? "null, null, false" : "true, null, true") 
							+ ");";
					document.getElementById("cutemenus-skin-enable").setAttribute("oncommand", cuteSkinCommand);
					document.getElementById("cutemenus-skin-enable").setAttribute("checked", this.skin); }
				
				if (this.skin && this.enabled)
				
					// activate officeXP-style menus
					for (var j = 0 ; j < this.cuteArray.length ; j++) {
						menuElements = document.getElementsByTagName(this.cuteArray[j]);
						for (var l = 0 ; l < menuElements.length ; l++)
							menuElements[l].setAttribute("cuteoffice", "true");
					}
					
				// if we're disabled, and already initialized the items
				else if (this.windowInit)
				
					// deactivate officeXP-style menus
					for (var p = 0 ; p < this.cuteArray.length ; p++) {
						menuElements = document.getElementsByTagName(this.cuteArray[p]);
						for (var r = 0 ; r < menuElements.length ; r++)
							menuElements[r].removeAttribute("cuteoffice");
					} 
			}

			// Window-init - end
			if (!this.windowInit)
				this.windowInit = true; // flag as initialized
    	}
    	
    	
	}
}

// runs the pref-observer once, by changing a dummy-pref 
//  -- called on first window-load
function initCuteMenusPrefObserver(evt) {
	window.document.removeEventListener("load", initCuteMenusPrefObserver, true); // remove context-menu listener
	
	try {
		var prefObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
		var Branch = prefObj.getBranch("cutemenus.");
		var tempPref = (Branch.prefHasUserValue("observer")) ? Branch.getCharPref("observer") : "-"; // default:'-'      :P

		switch (tempPref) {
			case "-": 
				Branch.setCharPref("observer", "*");
				break;
			case "*":
				Branch.setCharPref("observer", "-");
				break;
		}
	} catch(e) {}
	
}

// reveals context menu-items as needed
function cutemenusSetContext(evt) {

	// the popupshowing-event triggers first..
	if (evt.type == "popupshowing") {
		if (evt.target.id == "contentAreaContextMenu") 
			window.cmPrefObserver.menuShowing = false;
		else return; }
	// ..the mousemove-events then follow
	else {
		if (!window.cmPrefObserver.menuShowing && evt.type == "mousemove" && evt.shiftKey) {
			window.cmPrefObserver.menuShowing = true;
			// check for new themes (installed or manually added)
			cutemenusThemeCheck(); }
		else return;
	}

	// reveal relevant item(s)	
	gContextMenu.showItem('cutemenus-configmenu', (window.cmPrefObserver.menuShowing));
	
	if (!window.cmPrefObserver.menuShowing) return; // if not showing, don't bother with the rest
		
	gContextMenu.showItem('cutemenus-configtheme-cute', (true)); // change test to "window.cmPrefObserver.enabled" to make conditional
	gContextMenu.showItem('cutemenus-configtheme-qute', (true));
	gContextMenu.showItem('cutemenus-configtheme-gant', (true));
	gContextMenu.showItem('cutemenus-separator2', (true));
	gContextMenu.showItem('cutemenus-skin-enable', (true));	
	gContextMenu.showItem('cutemenus-separator1', (true));
	gContextMenu.showItem('cutemenus-config-enable', (true));	
}


// configures cutemenus, per user-options
function cutemenusConfig(enable, newTheme, useSkin) {
	var prefObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
	var Branch = prefObj.getBranch("cutemenus.");

	if (enable != null) Branch.setBoolPref("enabled", enable);
	if (newTheme != null) {
		if (Branch.prefHasUserValue("theme") && Branch.getCharPref("theme") == newTheme) 
			Branch.deleteBranch("theme"); // if we selected the active theme: reset the branch, to keep our menuitem checked
		Branch.setCharPref("theme", newTheme); }
	if (useSkin != null) Branch.setBoolPref("skin", useSkin);
}


// checks for external themes -- in the jar-file's directory
function cutemenusThemeCheck() {
	var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
	var dirArray = new Array();
	var chromeDir, cutemenusJar, themeDir;
	
	dirArray[0] = "AChrom"; // application-chrome magic-key
	dirArray[1] = "UChrm"; // profile-chrome magic-key
	
	// locate cutemenus jar-file
	for ( var i = 0 ; i < dirArray.length ; i++) {
		chromeDir = dirService.get(dirArray[i], Components.interfaces.nsIFile);
		cutemenusJar = chromeDir.clone();
		cutemenusJar.append("cutemenus.jar"); // "appends" the file-string to our dir file-obj
				
		if (cutemenusJar.exists()) {
			themeDir = chromeDir.clone();
			themeDir.append("CuteMenus Themes");
			if (themeDir.exists() && themeDir.isDirectory() && themeDir.isReadable()) {
				var themeArray = new Array();
				var enumerator = themeDir.directoryEntries; // list-out all subdir's in our Themes Folder
				while(enumerator.hasMoreElements())
					themeArray.push(enumerator.getNext());
				
				var cuteMenuEntry = document.getElementById("cutemenus-configtheme-default");
				var cuteSeparator = document.getElementById("cutemenus-separator");
				var boundingSeparator = cuteMenuEntry.previousSibling;
				var insertionPoint = (boundingSeparator && boundingSeparator.nodeName.toLowerCase() == "menuseparator") ? 
						boundingSeparator
						:
						cuteMenuEntry;
				
				// build new menu-entries from the leafnames of each subdir/jar
				for ( var n = 0, addSeparator, newMenuEntry, themeName, themePath, pathBreak, pathRe ; n < themeArray.length ; n++) {
					themeArray[n] = themeArray[n].QueryInterface(Components.interfaces.nsIFile); // break out of nsISupports-wrapper
					if (dirArray[i] == "UChrm") {
						pathBreak = themeArray[n].path.replace(/^.*chrome(\W*)cutemenus themes.*$/i, "$1").replace(/(.)/g, "\\$1");
						pathRe = new RegExp(pathBreak, "g");
						themePath = themeArray[n].path.replace(pathRe, "/"); 
						themePath = "file:///"+themePath; } // use full file-url if in profile-chrome
					else 
						themePath = "resource:/Chrome/CuteMenus Themes/"+themeArray[n].leafName; // use resource url if in app-chrome
					jarRe = new RegExp("\.jar$", "i"); // jar:file:///mewf/Documents/Mozilla/Profiles/bt2/hleerg98.slt/chrome/cutemenusXX.jar!/qute/reload.png
					if (jarRe.test(themePath)) themePath = "jar:"+themePath+"!"; // for jar-files, append prefix+suffix
					themePath += "/"; // append final path-break
					themeName = themeArray[n].leafName.replace(/\.jar$/i, ""); // get theme name, sans jar-extension
					
					// don't duplicate existing entries
					var oldMenuEntry = null, prevItem = cuteMenuEntry.previousSibling;
					while (!oldMenuEntry && prevItem) {
						if (prevItem.getAttribute("oncommand") == "event.preventDefault(); event.stopPropagation(); cutemenusConfig(true, '"+themePath+"', null);")
							oldMenuEntry = prevItem;
						prevItem = prevItem.previousSibling;
					}
					if (!oldMenuEntry) {
						newMenuEntry = document.createElement("menuitem");
						newMenuEntry.setAttribute("id", "cutemenus-configtheme-"+themeName);
						newMenuEntry.setAttribute("label", themeName);
						newMenuEntry.setAttribute("click", "event.preventDefault(); event.stopPropagation();");
						newMenuEntry.setAttribute("oncommand", "event.preventDefault(); event.stopPropagation(); cutemenusConfig(true, '"+themePath+"', null);");
						newMenuEntry.setAttribute("type", "checkbox");
						newMenuEntry.setAttribute("enabled", "true");
						cuteMenuEntry.parentNode.insertBefore(newMenuEntry, insertionPoint);
						if (window.cmPrefObserver.skin) cuteMenuEntry.setAttribute("cuteoffice", "true"); // skin element, if necessary
						addSeparator = true; }
				}
				// add separator, if any theme-entries were added and we don't already have one
				if (addSeparator && insertionPoint.nodeName.toLowerCase() != "menuseparator") {
					var newSeparator = document.createElement("menuseparator");
					if (window.cmPrefObserver.skin) newSeparator.setAttribute("cuteoffice", "true"); // skin element, if necessary
					cuteMenuEntry.parentNode.insertBefore(newSeparator, cuteMenuEntry); }
			}
			i = dirArray.length; // don't continue loop.
		}
	}
	
	
}