#GNU sed implements anchoring of subexpressions (optional according to
#POSIX), which means that "^" and "$" in "\(^foo\)" and "\(bar$\)" match
#the beginning and end of the pattern space respectively. However "^" not
#in the beginning of the regular expression, nor (optionally) in the
#beginning of subexpressions, should match a litteral "^" character.
#It doesn't seem to be the case:
#
#  $ echo '\(^' | gsed407 -n 's/\\(^/<&>/p'
#  $ echo '\(^' | gsed407 -n 's/\\(\^/<&>/p'
#  <\(^>
#
#on the other hand, when "^" is not following "\\(", it works okay:
#  $ echo '\(a^' | gsed407 -n 's/\\(a^/<&>/p'
#  <\(a^>

=
h
1s/\\(^/<&>/p
2s/\\(a^/<&>/p
g
1s/\\(\^/<&>/p
2s/\\(a\^/<&>/p
d
