/* rank.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../../src/rank.q on Sat Aug 25 19:50:47 2007.
   Do not modify!
 */
#line 1 "../../src/rank.q"
/* PSPP - RANK. -*-c-*-

Copyright (C) 2005 Free Software Foundation, Inc.
Author: John Darrington 2005

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA. */

#include <config.h>
#include "command.h"
#include "dictionary.h"
#include "sort.h"
#include "sort-prs.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 38 "rank.c"
#include <stdlib.h>
#include "alloc.h"
#include "error.h"
#include "lexer.h"
#include "settings.h"
#include "str.h"
#include "subclist.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 32 "../../src/rank.q"

#line 53 "rank.c"
#line 47 "../../src/rank.q"
#line 55 "rank.c"
/* Settings for subcommand specifiers. */
enum
  {
    RANK_YES = 1000,
    RANK_NO,
    RANK_EXCLUDE,
    RANK_INCLUDE
  };

#define MAXLISTS 10
/* RANK structure. */
struct cmd_rank
  {
    /* VARIABLES subcommand. */
    int sbc_variables;
    
    /* RANK subcommand. */
    int sbc_rank;
    
    /* NORMAL subcommand. */
    int sbc_normal;
    
    /* PERCENT subcommand. */
    int sbc_percent;
    
    /* NTILES subcommand. */
    int sbc_ntiles;
    
    /* RFRACTION subcommand. */
    int sbc_rfraction;
    
    /* PROPORTION subcommand. */
    int sbc_proportion;
    
    /* N subcommand. */
    int sbc_n;
    
    /* SAVAGE subcommand. */
    int sbc_savage;
    
    /* PRINT subcommand. */
    int sbc_print;
    long print;
    
    /* MISSING subcommand. */
    int sbc_missing;
    long miss;
  };

/* Prototype for custom subcommands of RANK. */
static int rank_custom_variables (struct cmd_rank *);
static int rank_custom_rank (struct cmd_rank *);
static int rank_custom_normal (struct cmd_rank *);
static int rank_custom_percent (struct cmd_rank *);
static int rank_custom_ntiles (struct cmd_rank *);
static int rank_custom_rfraction (struct cmd_rank *);
static int rank_custom_proportion (struct cmd_rank *);
static int rank_custom_n (struct cmd_rank *);
static int rank_custom_savage (struct cmd_rank *);

/* Command parsing functions. */
static int parse_rank (struct cmd_rank *);
static void free_rank (struct cmd_rank *);

#line 48 "../../src/rank.q"
#line 121 "rank.c"
static int
parse_rank (struct cmd_rank *p)
{
  p->sbc_variables = 0;
  p->sbc_rank = 0;
  p->sbc_normal = 0;
  p->sbc_percent = 0;
  p->sbc_ntiles = 0;
  p->sbc_rfraction = 0;
  p->sbc_proportion = 0;
  p->sbc_n = 0;
  p->sbc_savage = 0;
  p->sbc_print = 0;
  p->print = RANK_YES;
  p->sbc_missing = 0;
  p->miss = RANK_EXCLUDE;
  for (;;)
    {
      switch (rank_custom_variables (p))
        {
        case 0:
          goto lossage;
        case 1:
          p->sbc_variables++;
          continue;
        case 2:
          break;
        default:
          assert (0);
        }
      if (lex_match_id ("VARIABLES"))
        {
          lex_match ('=');
          p->sbc_variables++;
          if (p->sbc_variables > 1)
            {
              msg (SE, _("VARIABLES subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_variables (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("RANK"))
        {
          lex_match ('=');
          p->sbc_rank++;
          if (p->sbc_rank > 1)
            {
              msg (SE, _("RANK subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_rank (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("NORMAL"))
        {
          lex_match ('=');
          p->sbc_normal++;
          if (p->sbc_normal > 1)
            {
              msg (SE, _("NORMAL subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_normal (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("PERCENT"))
        {
          lex_match ('=');
          p->sbc_percent++;
          if (p->sbc_percent > 1)
            {
              msg (SE, _("PERCENT subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_percent (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("NTILES"))
        {
          lex_match ('=');
          p->sbc_ntiles++;
          if (p->sbc_ntiles > 1)
            {
              msg (SE, _("NTILES subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_ntiles (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("RFRACTION"))
        {
          lex_match ('=');
          p->sbc_rfraction++;
          if (p->sbc_rfraction > 1)
            {
              msg (SE, _("RFRACTION subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_rfraction (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("PROPORTION"))
        {
          lex_match ('=');
          p->sbc_proportion++;
          if (p->sbc_proportion > 1)
            {
              msg (SE, _("PROPORTION subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_proportion (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("N"))
        {
          lex_match ('=');
          p->sbc_n++;
          if (p->sbc_n > 1)
            {
              msg (SE, _("N subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_n (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("SAVAGE"))
        {
          lex_match ('=');
          p->sbc_savage++;
          if (p->sbc_savage > 1)
            {
              msg (SE, _("SAVAGE subcommand may be given only once."));
              goto lossage;
            }
          switch (rank_custom_savage (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("PRINT"))
        {
          lex_match ('=');
          p->sbc_print++;
          if (p->sbc_print > 1)
            {
              msg (SE, _("PRINT subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if ((lex_match_id ("ON") || lex_match_id ("YES") || lex_match_id ("TRUE")))
                p->print = RANK_YES;
              else if ((lex_match_id ("OFF") || lex_match_id ("NO") || lex_match_id ("FALSE")))
                p->print = RANK_NO;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("MISSING"))
        {
          lex_match ('=');
          p->sbc_missing++;
          if (p->sbc_missing > 1)
            {
              msg (SE, _("MISSING subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("EXCLUDE"))
                p->miss = RANK_EXCLUDE;
              else if (lex_match_id ("INCLUDE"))
                p->miss = RANK_INCLUDE;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if ( get_syntax() != COMPATIBLE && lex_match_id("ALGORITHM"))
        {
          lex_match ('=');
          if (lex_match_id("COMPATIBLE"))
            set_cmd_algorithm(COMPATIBLE);
          else if (lex_match_id("ENHANCED"))
            set_cmd_algorithm(ENHANCED);
          }
        if (!lex_match ('/'))
          break;
      }
    
    if (token != '.')
      {
        lex_error (_("expecting end of command"));
        goto lossage;
      }
      
    if ( 0 == p->sbc_variables)
    {
      msg (SE, _("VARIABLES subcommand must be given."));
      goto lossage;
    }
    
  return 1;
  
lossage:
  free_rank (p);
  return 0;
}

static void
free_rank (struct cmd_rank *p UNUSED)
{
}
#line 49 "../../src/rank.q"



enum RANK_FUNC
  {
    RANK,
    NORMAL,
    PERCENT,
    RFRACTION,
    PROPORTION,
    N,
    NTILES,
    SAVAGE,
  };


struct rank_spec
{
  enum RANK_FUNC rfunc;
  struct variable **destvars;
  struct variable *srcvar;
};


static struct rank_spec *rank_specs;
static int n_rank_specs;

static struct sort_criteria *sc;

static struct variable **group_vars;
static int n_group_vars;

static struct cmd_rank cmd;



int cmd_rank(void);

int
cmd_rank(void)
{
  int i;
  n_rank_specs = 0;

  if ( !parse_rank(&cmd) )
    return CMD_FAILURE;

#if 1
  for (i = 0 ; i <  sc->crit_cnt ; ++i )
    {
      struct sort_criterion *crit = &sc->crits[i];
      
      printf("Dir: %d; Index: %d\n", crit->dir, crit->fv);
    }

  for (i = 0 ; i <  n_group_vars ; ++i )
    printf("Group var: %s\n",group_vars[0]->name);

  for (i = 0 ; i <  n_rank_specs ; ++i )
    {
      int j;
      printf("Ranks spec %d; Func: %d\n",i, rank_specs[i].rfunc);
      
      for (j=0; j < sc->crit_cnt ; ++j )
	printf("Dest var is \"%s\"\n", rank_specs[i].destvars[j]->name);
    }
#endif 


  free(group_vars);
  
  for (i = 0 ; i <  n_rank_specs ; ++i )
    {
      free(rank_specs[i].destvars);
    }
      
  free(rank_specs);

  sort_destroy_criteria(sc);

  return CMD_SUCCESS;
}



/* Parser for the variables sub command  
   Returns 1 on success */
static int
rank_custom_variables(struct cmd_rank *cmd UNUSED)
{
  static const int terminators[2] = {T_BY, 0};

  lex_match('=');

  if ((token != T_ID || dict_lookup_var (default_dict, tokid) == NULL)
      && token != T_ALL)
      return 2;

  sc = sort_parse_criteria (default_dict, 0, 0, 0, terminators);

  if ( lex_match(T_BY)  )
    {
      if ((token != T_ID || dict_lookup_var (default_dict, tokid) == NULL))
	{
	  return 2;
	}

      if (!parse_variables (default_dict, &group_vars, &n_group_vars,
			    PV_NO_DUPLICATE | PV_NUMERIC | PV_NO_SCRATCH) )
	{
	  free (group_vars);
	  return 0;
	}
    }

  return 1;
}


/* Return a name for a new variable which ranks the variable VAR_NAME,
   according to the ranking function F.
   If IDX is non zero, then IDX is used as a disambiguating number.
   FIXME: This is not very robust.
*/
static char *
new_variable_name(const char *ranked_var_name, enum RANK_FUNC f, int idx)
{
  static char new_name[SHORT_NAME_LEN + 1];
  char temp[SHORT_NAME_LEN + 1];
 
  if ( idx == 0 ) 
    {
      switch (f) 
	{
	case RANK:
	case RFRACTION:
	  strcpy(new_name,"R");
	  break;

	case NORMAL:
	case N:
	case NTILES:
	  strcpy(new_name,"N");
	  break;
      
	case PERCENT:
	case PROPORTION:
	  strcpy(new_name,"P");
	  break;

	case SAVAGE:
	  strcpy(new_name,"S");
	  break;

	default:
	  assert(false);
	  break;
	}
  
      strncat(new_name, ranked_var_name, 7);
    }
  else
    {
      strncpy(temp, ranked_var_name, 3);
      snprintf(new_name, SHORT_NAME_LEN, "%s%03d", temp, idx);
    }

  return new_name;
}

/* Parse the [/rank INTO var1 var2 ... varN ] clause */
static int
parse_rank_function(struct cmd_rank *cmd UNUSED, enum RANK_FUNC f)
{
  static const struct fmt_spec f8_2 = {FMT_F, 8, 2};
  int var_count = 0;
  
  n_rank_specs++;
  rank_specs = xrealloc(rank_specs, n_rank_specs * sizeof *rank_specs);
  rank_specs[n_rank_specs - 1].rfunc = f;

  rank_specs[n_rank_specs - 1].destvars = 
	    xcalloc(sc->crit_cnt ,sizeof (struct variable *));
	  
  if (lex_match_id("INTO"))
    {
      struct variable *destvar;

      while( token == T_ID ) 
	{
	  ++var_count;
	  if ( dict_lookup_var (default_dict, tokid) != NULL )
	    {
	      msg(ME, _("Variable %s already exists."), tokid);
	      return 0;
	    }
	  if ( var_count > sc->crit_cnt ) 
	    {
	      msg(ME, _("Too many variables in INTO clause."));
	      return 0;
	    }

	  destvar = dict_create_var (default_dict, tokid, 0);
	  if ( destvar ) 
	    {
	      destvar->print = destvar->write = f8_2;
	    }
	  
	  rank_specs[n_rank_specs - 1].destvars[var_count - 1] = destvar ;

	  lex_get();
	  
	}
    }

  /* Allocate rank  variable names to all those which haven't had INTO 
     variables assigned */
  while (var_count < sc->crit_cnt)
    {
      static int idx=0;
      struct variable *destvar ; 
      const struct variable *v = dict_get_var(default_dict,
					      sc->crits[var_count].fv);

      char *new_name;
      
      do {
	new_name = new_variable_name(v->name, f, idx);

	destvar = dict_create_var (default_dict, new_name, 0);
	if (!destvar ) 
	  ++idx;

      } while( !destvar ) ;

      destvar->print = destvar->write = f8_2;

      rank_specs[n_rank_specs - 1].destvars[var_count] = destvar ;
      
      ++var_count;
    }

  return 1;
}


static int
rank_custom_rank(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, RANK);
}

static int
rank_custom_normal(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, NORMAL);
}

static int
rank_custom_percent(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, NORMAL);
}

static int
rank_custom_rfraction(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, RFRACTION);
}

static int
rank_custom_proportion(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, PROPORTION);
}

static int
rank_custom_n(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, N);
}

static int
rank_custom_savage(struct cmd_rank *cmd )
{
  return parse_rank_function(cmd, SAVAGE);
}


static int
rank_custom_ntiles(struct cmd_rank *cmd )
{
  if ( lex_force_match('(') ) 
    {
      if ( lex_force_int() ) 
	{
	  lex_get();
	  lex_force_match(')');
	}
      else
	return 0;
    }
  else
    return 0;

  return parse_rank_function(cmd, NTILES);
}


